#include <curses.h>
#include <math.h>
#include "bug5.h"

void die(struct bug *temp)
{
	mvwprintw(world_pad, temp->ypos,temp->xpos,"%c",FOOD1);

	if(temp == bugs)
		bugs = bugs->prev;
	if(temp == first)
		first = first->prev;
	if(temp == sb)
		sb = sb->prev;
	if(temp == hg)
		hg = hg->prev;
	if(temp == old)
		old = old->prev;
	if(temp == hk)
		hk = hk->prev;

	temp->prev->next = temp->next;
	temp->next->prev = temp->prev;

	if(bugs == bugs->next)
		stop();
	free(temp);
}

void mate(void)
{
	struct bug *temp;
	struct bug *mate;
	int loop2, val;
	char tempch[3];
	int distance = 1;
	int tmin, tmax;


	// where is the mate???
	if(bugs->food < SPLIT_LVL)
		switch(bugs->vector)
		{
			case 0:
				// screen up
				mate = findbug((bugs->ypos - 1 + world_row) % world_row,bugs->xpos);
				break;
			case 1:
				// screen right
				mate = findbug(bugs->ypos,(bugs->xpos + 1) % world_col);
				break;
			case 2:
				// screen down
				mate = findbug((bugs->ypos + 1) % world_row,bugs->xpos);
				break;
			case 3: 
				// screen left
				mate = findbug(bugs->ypos,(bugs->xpos - 1 + world_col) % world_col);
				break;                                          
			default:
				fprintf(stderr, "default in mate find bugs->vector is bad\n");
				break;
		}
	else
		mate = bugs;
	
	temp = (struct bug *) malloc (sizeof(struct bug));
	
	do
	{
		temp->ypos = -1;
		temp->xpos = -1;

		tmin = (bugs->ypos + world_row - getrandom(1, distance)) % world_row;
		tmax = (bugs->ypos + getrandom(1, distance)) % world_row;
		while ((temp->ypos < 0)||(temp->ypos > world_row))
			temp->ypos = tmin < tmax ? getrandom(tmin, tmax) : getrandom(tmax, tmin);

		tmin = (bugs->xpos + world_col - getrandom(1, distance)) % world_col;
		tmax = (bugs->xpos + getrandom(1, distance)) % world_col;
		while ((temp->xpos < 0)||(temp->xpos > world_col))
			temp->xpos = tmin < tmax ? getrandom(tmin, tmax) : getrandom(tmax, tmin);

		val = mvwinnstr(world_pad,temp->ypos,temp->xpos,tempch,1);
		
		distance++;
	}
	while(tempch[0] != SPACE);

	temp->race = bugs->race;
	temp->gen = bugs->gen + 1;
	temp->vector = getrandom(0,3);
	temp->age = 0;
	
	temp->size = bugs->size + getrandom(-D_SIZE,D_SIZE);
	if (temp->size < L_SIZE)
		temp->size = L_SIZE;
	if (temp->size > H_SIZE)
		temp->size = H_SIZE;

	temp->fov = bugs->fov + getrandom(-1,1);
	if (temp->fov < L_FOV)
		temp->fov = L_FOV;
	if (temp->fov > H_FOV)
		temp->fov = H_FOV;

	temp->food = bugs->food / 3;
	bugs->food = ((bugs->food * 2) / 3) - MATE_COST;

	for(loop2 = 0; loop2 < 256; loop2++)
		temp->things[loop2] = bugs->things[loop2] / RF;
	temp->things[FOOD3]++;
		
	for(loop2 = 0; loop2 <= S_LEN; loop2++)
	{
		switch(getrandom(0,8))
		{
			case 0:
			case 2:
			case 4:
			case 6: 
			case 8:
				// copy parent bugs
				temp->search[loop2] = bugs->search[loop2];      
				break;
			case 1:
			case 3:
			case 5:
				// copy parent mate
				temp->search[loop2] = mate->search[loop2];      
				break;
			case 7:
				// mutate
				temp->search[loop2] = getrandom(0,3);
				break;
			default:
				fprintf(stderr, "default in new genes ...\n");
				break;
		}
	}

	temp->next = bugs->next;
	bugs->next->prev = temp;
	bugs->next = temp;
	temp->prev = bugs;
	
	return;
}
