// Bug5 header file
#ifndef BUG5_H
#define BUG5_H 

#define getrandom( min, max ) ((rand() % (int) (((max) + 1) - (min))) + (min))

// size of world
float world_size;  // argv[1]
int world_col;     // (int)((COLS * world_size) + (9 - ((COLS * world_size) % 8)))
int world_row;     // (int)((LINES * world_size) + (9 - ((LINES * world_size) % 8)))
WINDOW *world_pad; // world_pad "the world"

// used to set intial condition in start() ...
#define NUM_FOOD (world_col * world_row * .1)
#define NUM_BUGS (world_col * world_row * .01)

// how much a '@' is worth
#define FOOD_VAL 15
// how much a bug is worth
#define FOOD_BUG (biten->size * 4 * FOOD_VAL)

// how much food is used in mateing
#define MATE_COST (FOOD_VAL * bugs->size)
// how much food required to mate
#define MATE_LVL (4 * MATE_COST)
// how much food is need to split
#define SPLIT_LVL (MATE_LVL * 2)

// racial forgetfulness
#define RF 2

// what races?
#define L_RACE 'A'
#define H_RACE 'Z'

// what sizes?
#define L_SIZE 2
#define H_SIZE 100
#define D_SIZE 5

// what fov?
#define L_FOV 1
#define H_FOV 10

// search legnth ... how many genes in the DNA ...
#define S_LEN 25 

// things bugs might see ...
#define FOOD1 '.'
#define FOOD2 '*'
#define FOOD3 '@'
#define SPACE ' '

// land stuff
#define HEIGHT 100
int roughness; // higer roughness = more WTR & MNT
int grid_size; // higer grid_size = larger WTR & MNT
#define WTR '~'
#define WTR_LVL 0
int wtr_c; // how much WTR is there?
#define MNT '#'
#define MNT_LVL 100
int mnt_c; // how much MNT is there?

// FOOD_RATE min = 1 ... higher = slower ... 1 = always ...
#define FOOD_RATE 10

// a bug does what ???
#define WAIT 0
#define LEFT 1
#define RIGHT 2
#define FORWARD 3
// and uses some food
#define UFF (1 + log10(bugs->size))
#define WAIT_F UFF
#define TURN_F (1.2 * UFF)
#define MOVE_F (1.5 * UFF)

// the bug structure
struct bug
{
	int xpos, ypos, vector;  
	int food;
	char race;
	int age;
	int gen;
	int size;
	int fov;
	int things[256];
	int search[S_LEN];
	struct bug *prev;
	struct bug *next;
};

// current & "first"
struct bug *bugs, *first;

// status, highfood, high gen, oldest bugs ...
struct bug *sb, *hf, *hg, *old, *hk;

// init.c
void init (void);
// set intial screen ...
void start(void);
// end program ...
void stop(void);

// look.c
// the main function ...
// examine environment dicide what to do ...
int look(int);
// what a bug sees here ...
char peek(int fw, int lr);

// mate_die.c
// reproduce ...
void mate(void);
// poor bug ... rest in piece ...
void die(struct bug* temp);

// findbug.c
// mate with who ???
struct bug* findbug(int y, int x);

// food.c
void growfood(void);
void placefood(void);

// edit.c
// edit bug race ... DNA
void edit(struct bug *eb);

// view_t.c
// view conents of vb->things[]
void edit(struct bug *vb);

// terrain.c 
// cataclysmic geological forces shaping the landscape
void generateterrain (void);

// stat.c
// display stats about bugs
void stat(void);

#endif /* BUG5_H */
