#include <curses.h>
#include <math.h>
#include "bug5.h"

#define DIM 21

char stuff[DIM][DIM];

void c_stuff(void)
{
        int loop_1;
        int loop_2;
	
	for(loop_1 = 0; loop_1 < DIM; loop_1++)
        {
                for(loop_2 = 0; loop_2 < DIM; loop_2++)
                {
                        stuff[loop_2][loop_1] = '+';

                        if(loop_2 == 10)
                        	stuff[loop_2][loop_1] = '|';

                        if(loop_1 == 10)
	                        stuff[loop_2][loop_1] = '-';
		}
	}
	stuff[10][10] = 'x';
}

void p_stuff(void)
{
        int loop_1;
        int loop_2;
	
	if(bugs == sb)
	{
		for(loop_1 = 0; loop_1 < DIM; loop_1++)
        	{
                	for(loop_2 = 0; loop_2 < DIM; loop_2++)
                        	fprintf(stderr,"%c",stuff[loop_2][loop_1]);
			fprintf(stderr,"\n");
        	}
		c_stuff();
	}
}

int is_bug(char temp)
{
	if (temp >= L_RACE && temp <= H_RACE)
		return(1);
	else
		return(0);
}

int is_pass(char temp)
{
	if ((temp == WTR)||(temp == MNT)||(is_bug(temp)))
		return(0);
	else
		return(1);
}

float motivate(char temp, int depth)
{
	float motivation = 0;

	if (bugs->food < MATE_LVL)
		motivation = (float)bugs->things[temp] / (float)depth;

	else if (temp == bugs->race)
		motivation = (float)(bugs->food - MATE_LVL) / (float)depth;
	
	else
		motivation = (float)bugs->things[temp] / (float)(depth * 2);
		
	return(motivation);
}

int look_c (int vec)
{
      	switch(vec%4)
       	{
		case(0):
			return(-1);
               		break;
       		case(2):
			return(1);
               		break;
		default:
			return(0);
			break;
	}
}

// recursive fractal look ...
float look_b(int depth, int vec, int yo, int xo)
{
	float weight = 0;
	int val;
	char temp[3];

	val = mvwinnstr(world_pad,(bugs->ypos + world_row + yo) % world_row,(bugs->xpos + world_col + xo) % world_col,temp,1);
	//stuff[10+xo][10+yo] = temp[0];

	weight += motivate(temp[0],depth);

	if(is_pass(temp[0])&&(depth < bugs->fov))
	{
        	weight += look_b(depth+1,vec,yo+look_c(vec+0),xo+look_c(vec+1));
                if(depth < bugs->fov - 1)
       	        {
        	        look_b(depth+2,vec+1,yo+look_c(vec+1),xo+look_c(vec+2));
        	        look_b(depth+2,vec+3,yo+look_c(vec+3),xo+look_c(vec+0));
		}
	}
	
	return(weight);
}

int look(int search)
{
	struct bug *biten;
	char temp;
	float leftw = 0, rightw = 0, forwardw = 0;
	
	// look for mate and/or food
	//fprintf(stderr,"look\n");
	
	temp = peek(1,0);
	if((temp == bugs->race)&&(bugs->food > MATE_LVL))
	{
		mate();
		// exausted ...
		return WAIT;
	} 
	
	if(bugs->things[temp] > 0)
	{
		if(temp == FOOD3)
		{
			placefood();  
			bugs->food += FOOD_VAL;
			return FORWARD;
		}
		if((is_bug(temp))&&(temp != bugs->race))
		{
			biten = findbug((bugs->ypos + look_c(bugs->vector) + world_row) % world_row,(bugs->xpos + look_c(bugs->vector + 1) + world_col) % world_col);
			biten->things[bugs->race]--;
			biten->food -= bugs->size * bugs->size;
			if(biten->food < 0)
			{
				bugs->food += biten->size * 3;
				bugs->things[biten->race] += biten->size;
				bugs->things[FOOD3]--;
				die(biten);
			}
			bugs->fov--;
			return WAIT;
		}
	}

	//c_stuff();
        forwardw = look_b(1,bugs->vector,look_c(bugs->vector+0),look_c(bugs->vector+1));
	//fprintf(stderr,"bv=%i forward=%f\n",bugs->vector,forwardw);
	//p_stuff();
        rightw = look_b(2,bugs->vector+1,look_c(bugs->vector+1),look_c(bugs->vector+2));
	//fprintf(stderr,"bv=%i right=%f\n",bugs->vector,rightw);
	//p_stuff();
        leftw = look_b(2,bugs->vector+3,look_c(bugs->vector+3),look_c(bugs->vector+0));
	//fprintf(stderr,"bv=%i left=%f\n",bugs->vector,leftw);
	//p_stuff();
        forwardw -= look_b(3,bugs->vector+2,look_c(bugs->vector+2),look_c(bugs->vector+3));
	//fprintf(stderr,"bv=%i back=%f\n",bugs->vector,forwardw);
	//p_stuff();
	
	if((leftw > 0)||(rightw > 0)||(forwardw > 0))	
	{
		// forward > left & right
		if((forwardw > leftw)&&(forwardw > rightw))
	        {
	        	if((forwardw > 0)&&(is_pass(temp)))
        	        	return FORWARD;
	                else if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
        			return bugs->search[search];
        	        else
		       	       	return getrandom(LEFT,RIGHT);
		}
		// left > forward & right
		if((leftw > rightw)&&(leftw > forwardw))
	        {
	        	if(leftw > 0)
        	        	return LEFT;
	                else if(is_pass(temp))
        	        {
        	        	if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
        	        		return bugs->search[search];
				else
	        	        	return getrandom(RIGHT, FORWARD);
			}
			else
				return RIGHT;
		}
		// right > left & forward
		if((rightw > leftw)&&(rightw > forwardw))
	        {
	        	if(rightw > 0)
        	        	return RIGHT;
			else if (is_pass(temp))
			{
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			}
			else 
				return LEFT;
		}	
		// left & right > forward
		if((leftw == rightw)&&(rightw > forwardw))
	        {
	        	if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
	        		return bugs->search[search];
	        	else
	        		return getrandom(LEFT,RIGHT);
		}
		// forward & right > left
		if((forwardw == rightw)&&(rightw > leftw))
                {
                	if(is_pass(temp))
			{
				if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return getrandom(RIGHT,FORWARD);
			}
			else
				return RIGHT;
		}	
		// forward & left > right
		if((forwardw == leftw)&&(leftw > rightw))
                {
                	if(is_pass(temp))
			{
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			}
			else
				return LEFT;
		}
		// all equil
        	if(is_pass(temp))
        	{
        		if(bugs->search[search] == WAIT)
        			return getrandom(LEFT, FORWARD);
        		else
        			return bugs->search[search];
		}
		else
		{
			if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
				return bugs->search[search];
			else
				return getrandom(LEFT, RIGHT);
		}
	}
	// default din't see anything good ...
        if((!is_pass(temp))&&(bugs->search[search] == FORWARD))
		return getrandom(WAIT, RIGHT);

	return bugs->search[search];
}

char peek(int fw, int lr)
{
	int val;
	char temp[3];
	
	switch(bugs->vector)
	{
		case 0:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - fw) % world_row,(bugs->xpos + world_col + lr) % world_col,temp,1);
			break;
		case 1:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + lr) % world_row,(bugs->xpos + world_col + fw) % world_col,temp,1);
			break;
		case 2:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + fw) % world_row,(bugs->xpos + world_col - lr) % world_col,temp,1);
                        break;
		case 3:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - lr) % world_row,(bugs->xpos + world_col - fw) % world_col,temp,1);
			break;
		default:
			fprintf(stderr,"default in peek bugs->vector is bad\n");
			break;   
	}
	return(temp[0]);
}
