#include <curses.h>
#include <math.h>
#include "bug4.h"

void generateterrain (void)
{
	int elevation_map [world_col][world_row];
	int x, y;
	int grid_s = pow(2,grid_size);
	
	/* define primary grid */
	for (x=0; x<world_col; x+=grid_s) {
		for (y=0; y<world_row; y+=grid_s) {
			elevation_map[x][y] = getrandom (0,HEIGHT);
		}
	}

	for (grid_s/=2; grid_s >= 1; grid_s/=2) {	
		/* interpolate smaller grid along horizontals */
		for (x=grid_s; x<world_col; x+=grid_s*2) {
			for (y=0; y<world_row; y+=grid_s*2) {
				elevation_map[x][y] = getrandom (-roughness*log10(grid_s),roughness*log10(grid_s)) + (elevation_map[x-grid_s][y] + elevation_map[(x+grid_s<world_col)?(x+grid_s):(0)][y])/2;
			}
		}
		/* interpolate smaller grid along verticals */
		for (x=0; x<world_col; x+=grid_s*2) {
			for (y=grid_s; y<world_row; y+=grid_s*2) {
				elevation_map[x][y] = getrandom (-roughness*log10(grid_s),roughness*log10(grid_s)) + (elevation_map[x][y-grid_s] + elevation_map[x][(y+grid_s<world_row)?(y+grid_s):(0)])/2;
			}
		}
		/* interpolate smaller grid between gridlines */
		for (x=grid_s; x<world_col; x+=grid_s*2) {
			for (y=grid_s; y<world_row; y+=grid_s*2) {
				elevation_map[x][y] = getrandom (-roughness*log10(grid_s),roughness*log10(grid_s)) + (elevation_map[x][y-grid_s] + elevation_map[x][(y+grid_s<world_row)?(y+grid_s):(0)] + elevation_map[(x+grid_s<world_col)?(x+grid_s):(0)][y] + elevation_map[x-grid_s][y])/4;
			}
		}
	}

	// place WTR's and MNT's
	wtr_c = 0;
	mnt_c = 0;

	for (x=0; x<world_col; x++) 
	{
		for (y=0; y<world_row; y++) 
		{
			if (elevation_map[x][y] <= WTR_LVL) 
			{
				mvwprintw(world_pad, y, x,"%c",WTR);
				wtr_c++;
			}
			if (elevation_map[x][y] >= MNT_LVL) 
			{
				mvwprintw(world_pad, y, x,"%c",MNT);
				mnt_c++;
			}
		}
	}

	if (((world_col * world_row) - wtr_c - mnt_c) < (10 * NUM_BUGS))
	{
		fprintf(stderr,"bad terrain\n");
		stop();
	}
}
