#include <curses.h>
#include "bug4.h"

void init(void)
{
	initscr();

	// set world dimensions	
	// important COLS & LINES == 0 till after initscr()
	world_col = (int)(COLS * world_size);
	world_row = (int)(LINES * world_size);
	
	init_kb();
	srand((unsigned) time ( NULL ));
	world_pad = newpad(world_row, world_col);
	clear();
	start();
}

void start(void)
{
	struct bug *temp, *x;
	int loop, loop2, val;
	char tempch[3];

	// generate underlying terrain
	generateterrain();

	// place food
	for(loop = 1; loop <= NUM_FOOD; loop++)
		placefood();
	
	// create bugs
	for(loop = 1; loop <= NUM_BUGS; loop++)
	{
		temp = (struct bug *) malloc (sizeof(struct bug));

		// don't put bugs on MNT or in WTR
		while(tempch[0] != SPACE)
		{
			temp->xpos = getrandom(0,world_col-1);
			temp->ypos = getrandom(0,world_row-1);
			val = mvwinnstr(world_pad,temp->ypos,temp->xpos,tempch,1);
		}

		temp->vector = getrandom(0,3);
		temp->race = (char) getrandom(L_RACE,H_RACE);
		temp->size = getrandom(L_SIZE,H_SIZE);
		temp->fov = getrandom(L_FOV,H_FOV);
		temp->food = 100 * temp->size;
		temp->gen = 1;
		temp->age = 0;

		for(loop2 = 0; loop2 <= S_LEN; loop2++)
			temp->search[loop2] = getrandom(0,3);
		
		for(loop2 = 0; loop2 < 256; loop2++)
		{
			if(is_bug((char)loop2))
				temp->things[loop2] = 1;
			else
				temp->things[loop2] = 0;
		}
		temp->things[FOOD3] = FOOD_VAL;
		
		if(loop == 1)
			bugs = temp;
		else
		{
			x->next = temp;
			temp->prev = x;
		}
		x = temp;
	}
	temp->next = bugs;
	bugs->prev = temp;
	return;
}

void stop(void)
{
	delwin(world_pad);
	close_kb();
	endwin();
	exit(0);
}
