#include <curses.h>
#include <math.h>
#include "bug5.h"

int is_bug(char temp)
{
	if (temp >= L_RACE && temp <= H_RACE)
		return(1);
	else
		return(0);
}

int is_pass(char temp)
{
	if ((temp == WTR)||(temp == MNT)||(is_bug(temp)))
		return(0);
	else
		return(1);
}

float motivate(char temp, int depth)
{
	float motivation = 0;

	if (bugs->food < MATE_LVL)
		motivation = (float)bugs->things[temp] / (float)depth;

	else if (temp == bugs->race)
		motivation = (float)(bugs->food - MATE_LVL) / (float)depth;
	
	else
		motivation = (float)bugs->things[temp] / (float)(depth * 2);
		
	return(motivation);
}

int look_c (int vec)
{
      	switch(vec%4)
       	{
		case(0):
			return(-1);
               		break;
       		case(2):
			return(1);
               		break;
		default:
			return(0);
			break;
	}
}

// recursive fractal look ...
float look_b(int depth, int vec, int yo, int xo)
{
	float weight = 0;
	int val;
	char temp[3];

	val = mvwinnstr(world_pad,(bugs->ypos + world_row + yo) % world_row,(bugs->xpos + world_col + xo) % world_col,temp,1);
	weight += motivate(temp[0],depth);

	if(is_pass(temp[0])&&(depth < bugs->fov))
	{
        	weight += look_b(depth+1,vec,yo+look_c(vec+0),xo+look_c(vec+1));
                if(depth < bugs->fov - 1)
       	        {
        	        look_b(depth+2,vec+1,yo+look_c(vec+1),xo+look_c(vec+2));
        	        look_b(depth+2,vec+3,yo+look_c(vec+3),xo+look_c(vec+0));
		}
	}
	
	return(weight);
}

int look(int search)
{
	struct bug *biten;
	char temp;
	float leftw = 0, rightw = 0, forwardw = 0;
	
	// look for mate and/or food
	temp = peek(1,0);
	if((temp == bugs->race)&&(bugs->food > MATE_LVL))
	{
		mate();
		// exausted ...
		return WAIT;
	} 
	
	if(bugs->things[temp] > 0)
	{
		if(temp == FOOD3)
		{
			placefood();  
			bugs->food += FOOD_VAL;
			return FORWARD;
		}
		if((is_bug(temp))&&(temp != bugs->race))
		{
			biten = findbug((bugs->ypos + look_c(bugs->vector) + world_row) % world_row,(bugs->xpos + look_c(bugs->vector + 1) + world_col) % world_col);
			if(bugs->things[FOOD3] < 0)
				biten->things[bugs->race] -= bugs->size;
			biten->food -= bugs->size;
			if(biten->food < 0)
			{
				bugs->food += FOOD_BUG;
				bugs->things[biten->race] += biten->size;
				bugs->things[FOOD3] -= biten->size;
				die(biten);
			}
			bugs->fov--;
			return WAIT;
		}
	}

        forwardw = look_b(1,bugs->vector,look_c(bugs->vector+0),look_c(bugs->vector+1));
        rightw = look_b(2,bugs->vector+1,look_c(bugs->vector+1),look_c(bugs->vector+2));
        leftw = look_b(2,bugs->vector+3,look_c(bugs->vector+3),look_c(bugs->vector+0));
        forwardw -= look_b(3,bugs->vector+2,look_c(bugs->vector+2),look_c(bugs->vector+3));
	
	if((leftw > 0)||(rightw > 0)||(forwardw > 0))	
	{
		// forward > left & right
		if((forwardw > leftw)&&(forwardw > rightw))
	        {
	        	if((forwardw > 0)&&(is_pass(temp)))
        	        	return FORWARD;
	                else if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
        			return bugs->search[search];
        	        else
		       	       	return getrandom(LEFT,RIGHT);
		}
		// left > forward & right
		if((leftw > rightw)&&(leftw > forwardw))
	        {
	        	if(leftw > 0)
        	        	return LEFT;
	                else if(is_pass(temp))
        	        {
        	        	if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
        	        		return bugs->search[search];
				else
	        	        	return getrandom(RIGHT, FORWARD);
			}
			else
				return RIGHT;
		}
		// right > left & forward
		if((rightw > leftw)&&(rightw > forwardw))
	        {
	        	if(rightw > 0)
        	        	return RIGHT;
			else if (is_pass(temp))
			{
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			}
			else 
				return LEFT;
		}	
		// left & right > forward
		if((leftw == rightw)&&(rightw > forwardw))
	        {
	        	if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
	        		return bugs->search[search];
	        	else
	        		return getrandom(LEFT,RIGHT);
		}
		// forward & right > left
		if((forwardw == rightw)&&(rightw > leftw))
                {
                	if(is_pass(temp))
			{
				if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return getrandom(RIGHT,FORWARD);
			}
			else
				return RIGHT;
		}	
		// forward & left > right
		if((forwardw == leftw)&&(leftw > rightw))
                {
                	if(is_pass(temp))
			{
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			}
			else
				return LEFT;
		}
		// all equil
        	if(is_pass(temp))
        	{
        		if(bugs->search[search] == WAIT)
        			return getrandom(LEFT, FORWARD);
        		else
        			return bugs->search[search];
		}
		else
		{
			if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
				return bugs->search[search];
			else
				return getrandom(LEFT, RIGHT);
		}
	}
	// default din't see anything good ...
        if((!is_pass(temp))&&(bugs->search[search] == FORWARD))
		return getrandom(WAIT, RIGHT);

	return bugs->search[search];
}

char peek(int fw, int lr)
{
	int val;
	char temp[3];
	
	switch(bugs->vector)
	{
		case 0:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - fw) % world_row,(bugs->xpos + world_col + lr) % world_col,temp,1);
			break;
		case 1:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + lr) % world_row,(bugs->xpos + world_col + fw) % world_col,temp,1);
			break;
		case 2:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + fw) % world_row,(bugs->xpos + world_col - lr) % world_col,temp,1);
                        break;
		case 3:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - lr) % world_row,(bugs->xpos + world_col - fw) % world_col,temp,1);
			break;
		default:
			fprintf(stderr,"default in peek bugs->vector is bad\n");
			break;   
	}
	return(temp[0]);
}
