#include <limits.h>
#include <curses.h>
#include "bug3.h"

#define NUM_XPMD 92
char xpm_digits[NUM_XPMD] = " .+@#$%&*=-;>,\')!~{]^/(_:<[}|1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`";

void generateterrain (void)
{
	//int elevation_map [world_col][world_row];
	int grid_size = GRID_SIZE;
	int x;
	int y;
	int loop;
	
	#ifdef DEBUG
	 fprintf (stderr, "Generating primary grid...\n");
	#endif
	/* define primary grid */
	for (x=0; x<world_col; x+=grid_size) {
		for (y=0; y<world_row; y+=grid_size) {
			world[x][y].elevation = getrandom (0,HEIGHT);
			if (world[x][y].elevation < SEA_LEVEL) {
				world[x][y].contents = WATER;
			}
			else {
				world[x][y].contents = SPACE;
			}
			world[x][y].resident = NULL;
			world[x][y].food_value = 0;
		}
	}

	for (grid_size/=2; grid_size >= 1; grid_size/=2) {	
		#ifdef DEBUG
		 fprintf (stderr, "Reticulating splines (grid size %i)...\n", grid_size);
		 fprintf (stderr, "Interpolating horizontally...\n");
		#endif
		/* interpolate smaller grid along horizontals */
		for (x=grid_size; x<world_col; x+=grid_size*2) {
			for (y=0; y<world_row; y+=grid_size*2) {
				world[x][y].elevation = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (world[x-grid_size][y].elevation + world[(x+grid_size<world_col)?(x+grid_size):(0)][y].elevation)/2;
				if (world[x][y].elevation < SEA_LEVEL) {
					world[x][y].contents = WATER;
				}
				else {
					world[x][y].contents = SPACE;
				}
				world[x][y].resident = NULL;
				world[x][y].food_value = 0;
			}
		}
		#ifdef DEBUG
		 fprintf (stderr, "Interpolating vertically...\n");
		#endif
		/* interpolate smaller grid along verticals */
		for (x=0; x<world_col; x+=grid_size*2) {
			for (y=grid_size; y<world_row; y+=grid_size*2) {
				world[x][y].elevation = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (world[x][y-grid_size].elevation + world[x][(y+grid_size<world_row)?(y+grid_size):(0)].elevation)/2;
				if (world[x][y].elevation < SEA_LEVEL) {
					world[x][y].contents = WATER;
				}
				else {
					world[x][y].contents = SPACE;
				}
				world[x][y].resident = NULL;
				world[x][y].food_value = 0;
			}
		}
		#ifdef DEBUG
		 fprintf (stderr, "Interpolating centerpoints...\n");
		#endif
		/* interpolate smaller grid between gridlines */
		for (x=grid_size; x<world_col; x+=grid_size*2) {
			for (y=grid_size; y<world_row; y+=grid_size*2) {
				world[x][y].elevation = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (world[x][y-grid_size].elevation + world[x][(y+grid_size<world_row)?(y+grid_size):(0)].elevation + world[(x+grid_size<world_col)?(x+grid_size):(0)][y].elevation + world[x-grid_size][y].elevation)/4;
				if (world[x][y].elevation < SEA_LEVEL) {
					world[x][y].contents = WATER;
				}
				else {
					world[x][y].contents = SPACE;
				}
				world[x][y].resident = NULL;
				world[x][y].food_value = 0;
			}
		}
	}
	// place blocks ..
	for(loop = 1; loop <= NUM_BLOCKS; loop++) {
		x = getrandom(0,world_col-1);
		y = getrandom(0,world_row-1);
		if (world[x][y].contents == SPACE) {
			world[x][y].contents = BLOCK;
			mvwprintw(world_pad, y, x, "%c", BLOCK);
		}
	}

	for (x=0; x<world_col; x++) {
		for (y=0; y<world_row; y++) {
			mvwprintw(world_pad, y, x, "%c", world[x][y].contents);
		}
	}

}	

void printxpm (void)
{
	int i, x, y, z;
	int min_elevation = INT_MAX;
	int max_elevation = INT_MIN;
	FILE *snapshot;
	if (snapshot = fopen ("bug.xpm", "wb") ) {
		for (y=0; y<world_row; y++) {
			for (x=0; x<world_col; x++) {
				if (world[x][y].elevation > max_elevation) max_elevation = world[x][y].elevation;
				if (world[x][y].elevation < min_elevation) min_elevation = world[x][y].elevation;
			}
		}
		fprintf (snapshot, "/* XPM */\nstatic char * bugs_xpm[] = {\n");
		fprintf (snapshot, "\"%i %i %i 2\",\n", world_col, world_row, (max_elevation-min_elevation+1)*3 + 6);
		fprintf (snapshot, "\"%c%c     c #0000FF\",\n", xpm_digits[0%NUM_XPMD], xpm_digits[0/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #CCCCCC\",\n", xpm_digits[1%NUM_XPMD], xpm_digits[1/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #FFFFFF\",\n", xpm_digits[2%NUM_XPMD], xpm_digits[2/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #FFFF00\",\n", xpm_digits[3%NUM_XPMD], xpm_digits[3/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #000000\",\n", xpm_digits[4%NUM_XPMD], xpm_digits[4/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c none\",\n", xpm_digits[5%NUM_XPMD], xpm_digits[5/NUM_XPMD]);
		for (i=0; i<=(max_elevation-min_elevation); i++) {
			fprintf (snapshot, "\"%c%c     c #%2.2X%2.2X%2.2X\",\n", xpm_digits[((i*3)+6)%NUM_XPMD], xpm_digits[((i*3)+6)/NUM_XPMD], (i*0xFF)/(max_elevation-min_elevation+1), (i*0xCC)/(max_elevation-min_elevation+1), 0);
			fprintf (snapshot, "\"%c%c     c #%2.2X%2.2X%2.2X\",\n", xpm_digits[((i*3)+7)%NUM_XPMD], xpm_digits[((i*3)+7)/NUM_XPMD], 0, (i*0xFF)/(max_elevation-min_elevation+1), 0);
			fprintf (snapshot, "\"%c%c     c #%2.2X%2.2X%2.2X\",\n", xpm_digits[((i*3)+8)%NUM_XPMD], xpm_digits[((i*3)+8)/NUM_XPMD], 0, (i*0xCC)/(max_elevation-min_elevation+1), 0);
		}
		for (y=0; y<world_row; y++) {
			fprintf (snapshot, "\"");
			for (x=0; x<world_col; x++) {
				if ( world[x][y].resident ) {
					if (world[x][y].resident->predlvl < 0) {
						fprintf (snapshot, "%c%c", xpm_digits [2%NUM_XPMD], xpm_digits [2/NUM_XPMD]);
					}
					else {
						fprintf (snapshot, "%c%c", xpm_digits [4%NUM_XPMD], xpm_digits [4/NUM_XPMD]);
					}
				}
				else if (world[x][y].contents == SPACE) {
					fprintf (snapshot, "%c%c", xpm_digits [(((world[x][y].elevation-min_elevation)*3)+6)%NUM_XPMD], xpm_digits [(((world[x][y].elevation-min_elevation)*3)+6)/NUM_XPMD]);
				}
				else if (world[x][y].contents == WATER) {
					fprintf (snapshot, "%c%c", xpm_digits [0%NUM_XPMD], xpm_digits [0/NUM_XPMD]);
				} 
				else if (world[x][y].contents == BLOCK) {
					fprintf (snapshot, "%c%c", xpm_digits [1%NUM_XPMD], xpm_digits [1/NUM_XPMD]);
				}
				else if ( world[x][y].contents==CARRION1 || world[x][y].contents==CARRION2 || world[x][y].contents==CARRION3 ) {
					fprintf (snapshot, "%c%c", xpm_digits [3%NUM_XPMD], xpm_digits [3/NUM_XPMD]);
				}
				else if ( world[x][y].contents==FOOD1 || world[x][y].contents==FOOD2 || world[x][y].contents==FOOD3 ) {
					fprintf (snapshot, "%c%c", xpm_digits [(((world[x][y].elevation-min_elevation)*3)+7)%NUM_XPMD], xpm_digits [(((world[x][y].elevation-min_elevation)*3)+7)/NUM_XPMD]);
				}
				else if ( world[x][y].contents==FOOD21 || world[x][y].contents==FOOD22 || world[x][y].contents==FOOD23 ) {
					fprintf (snapshot, "%c%c", xpm_digits [(((world[x][y].elevation-min_elevation)*3)+8)%NUM_XPMD], xpm_digits [(((world[x][y].elevation-min_elevation)*3)+8)/NUM_XPMD]);
				}
				else {
					fprintf (snapshot, "%c%c", xpm_digits [5%NUM_XPMD], xpm_digits [5/NUM_XPMD]);
				}
	
			}
			if (y == world_row-1) {
				fprintf (snapshot, "\"};\n");
			}
			else {
				fprintf (snapshot, "\",\n");
			}
		}
		fclose (snapshot);
	}
}

