#include <curses.h>
#include <limits.h>
#include "bug3.h"

#define MIN 0
#define AVERAGE 1
#define MAX 2

struct counts
{ 
	int pop;
	int race;
	int age [3];
	int food [3];
	int gen [3];
	int pred [3];
	int size [3]; 
};

int cmp_race(const void *i1, const void *i2)
{
	struct counts r1 = * (struct counts *) i1;
	struct counts r2 = * (struct counts *) i2;
	switch (statsort) {
		case 0: // sort by race
			return (r1.race - r2.race);
		case 1: // sort by population
			return (r2.pop - r1.pop);
		case 2: // sort by age
			return (r2.age[AVERAGE] - r1.age[AVERAGE]);
		case 3: // sort by food level
			return (r2.food[AVERAGE] - r1.food[AVERAGE]);
		case 4: // sort by generation
			return (r2.gen[MAX] - r1.gen[MAX]);
		case 5: // sort by predlevel
			return (r2.pred[AVERAGE] - r1.pred[AVERAGE]);
		case 6: // sort by size
			return (r2.size[AVERAGE] - r1.size[AVERAGE]);
		default: // no sort
			return 0;
	}
}

void init_counts (struct counts *temp)
{
 	temp->pop = 0;
	temp->age[MIN] = INT_MAX;
	temp->food[MIN] = INT_MAX;
	temp->gen[MIN] = INT_MAX;
	temp->pred[MIN] = INT_MAX;	
	temp->size[MIN] = INT_MAX;
 	temp->age[AVERAGE] = 0;
	temp->food[AVERAGE] = 0;
	temp->gen[AVERAGE] = 0;
 	temp->pred[AVERAGE] = 0;	
	temp->size[AVERAGE] = 0;
	temp->age[MAX] = INT_MIN;
	temp->food[MAX] = INT_MIN;
	temp->gen[MAX] = INT_MIN;
	temp->pred[MAX] = INT_MIN;	
	temp->size[MAX] = INT_MIN;
 	return;
}

void stat(void)
{
	struct bug *tempbug = bugs;
	struct counts races[256];
	int temp;
	
	for(temp = 0;temp < 256;temp++) {
		init_counts(&races[temp]);
		races[temp].race = temp;
	}
	while(races[0].pop < population)
	{
 		races[0].age[AVERAGE] += tempbug->age;
		if (tempbug->age < races[0].age[MIN]) races[0].age[MIN] = tempbug->age;
		if (tempbug->age > races[0].age[MAX]) races[0].age[MAX] = tempbug->age;
		races[0].food[AVERAGE] += tempbug->food;
		if (tempbug->food < races[0].food[MIN]) races[0].food[MIN] = tempbug->food;
		if (tempbug->food > races[0].food[MAX]) races[0].food[MAX] = tempbug->food;
		races[0].gen[AVERAGE] += tempbug->generation;
		if (tempbug->generation < races[0].gen[MIN]) races[0].gen[MIN] = tempbug->generation;
		if (tempbug->generation > races[0].gen[MAX]) races[0].gen[MAX] = tempbug->generation;
 		races[0].pred[AVERAGE] += tempbug->predlvl;
		if (tempbug->predlvl < races[0].pred[MIN]) races[0].pred[MIN] = tempbug->predlvl;
		if (tempbug->predlvl > races[0].pred[MAX]) races[0].pred[MAX] = tempbug->predlvl;
		races[0].size[AVERAGE] += tempbug->size;
		if (tempbug->size < races[0].size[MIN]) races[0].size[MIN] = tempbug->size;
		if (tempbug->size > races[0].size[MAX]) races[0].size[MAX] = tempbug->size;
 		
 		races[tempbug->race].pop++;

 		races[tempbug->race].age[AVERAGE] += tempbug->age;
		if (tempbug->age < races[tempbug->race].age[MIN]) races[tempbug->race].age[MIN] = tempbug->age;
		if (tempbug->age > races[tempbug->race].age[MAX]) races[tempbug->race].age[MAX] = tempbug->age;
		races[tempbug->race].food[AVERAGE] += tempbug->food;
		if (tempbug->food < races[tempbug->race].food[MIN]) races[tempbug->race].food[MIN] = tempbug->food;
		if (tempbug->food > races[tempbug->race].food[MAX]) races[tempbug->race].food[MAX] = tempbug->food;
		races[tempbug->race].gen[AVERAGE] += tempbug->generation;	
		if (tempbug->generation < races[tempbug->race].gen[MIN]) races[tempbug->race].gen[MIN] = tempbug->generation;
		if (tempbug->generation > races[tempbug->race].gen[MAX]) races[tempbug->race].gen[MAX] = tempbug->generation;
 		races[tempbug->race].pred[AVERAGE] += tempbug->predlvl;
		if (tempbug->predlvl < races[tempbug->race].pred[MIN]) races[tempbug->race].pred[MIN] = tempbug->predlvl;
		if (tempbug->predlvl > races[tempbug->race].pred[MAX]) races[tempbug->race].pred[MAX] = tempbug->predlvl;
		races[tempbug->race].size[AVERAGE] += tempbug->size;
		if (tempbug->size < races[tempbug->race].size[MIN]) races[tempbug->race].size[MIN] = tempbug->size;
		if (tempbug->size > races[tempbug->race].size[MAX]) races[tempbug->race].size[MAX] = tempbug->size;

		tempbug = tempbug->next;
		races[0].pop++;
	}	
	
	for(temp = 0;temp < 256;temp++)
		if(races[temp].pop != 0)	
		{
 			races[temp].age[AVERAGE] /= races[temp].pop;
			races[temp].food[AVERAGE] /= races[temp].pop;
			races[temp].gen[AVERAGE] /= races[temp].pop;
 			races[temp].pred[AVERAGE] /= races[temp].pop;
			races[temp].size[AVERAGE] /= races[temp].pop;
		}
	if (statrace == '\0') {
		clear ();	     
		wprintw(stdscr,"Status -----------------------------------------------------------------\n");
		wprintw(stdscr,"race	pop	age	amax	food	gen	pmin	pred	pmax	size\n");
		wprintw(stdscr,"all	%i	%i	%i	%i	%i	%i	%i	%i	%i\n",races[0].pop,races[0].age[AVERAGE],races[0].age[MAX],races[0].food[AVERAGE],races[0].gen[MAX],races[0].pred[MIN],races[0].pred[AVERAGE],races[0].pred[MAX],races[0].size[AVERAGE]);
	
		qsort(races, 256, sizeof(struct counts), cmp_race);
		
		for(temp = 1;temp < 256; temp ++) {
			if (races[temp].pop > 0) {
				wprintw(stdscr,"%c	%i	%i	%i	%i	%i	%i	%i	%i	%i\n",races[temp].race,races[temp].pop,races[temp].age[AVERAGE],races[temp].age[MAX],races[temp].food[AVERAGE],races[temp].gen[MAX],races[temp].pred[MIN],races[temp].pred[AVERAGE],races[temp].pred[MAX],races[temp].size[AVERAGE]);
			}
		}
	}
	else {
		clear ();
		wprintw(stdscr,"Stats for race '%c':\n", statrace);
		wprintw(stdscr, "Population: %i\n", races[statrace].pop);
		wprintw(stdscr, "Food\t(min): %i\n", races[statrace].food[MIN]);
		wprintw(stdscr, "\t(avg): %i\n", races[statrace].food[AVERAGE]);
		wprintw(stdscr, "\t(max): %i\n", races[statrace].food[MAX]);
		wprintw(stdscr, "Pred.\t(min): %i\n", races[statrace].pred[MIN]);
		wprintw(stdscr, "\t(avg): %i\n", races[statrace].pred[AVERAGE]);
		wprintw(stdscr, "\t(max): %i\n", races[statrace].pred[MAX]);
		wprintw(stdscr, "Size\t(min): %i\n", races[statrace].size[MIN]);
		wprintw(stdscr, "\t(avg): %i\n", races[statrace].size[AVERAGE]);
		wprintw(stdscr, "\t(max): %i\n", races[statrace].size[MAX]);
		wprintw(stdscr, "Age\t(min): %i\n", races[statrace].age[MIN]);
		wprintw(stdscr, "\t(avg): %i\n", races[statrace].age[AVERAGE]);
		wprintw(stdscr, "\t(max): %i\n", races[statrace].age[MAX]);
		wprintw(stdscr, "Gen.\t(min): %i\n", races[statrace].gen[MIN]);
		wprintw(stdscr, "\t(avg): %i\n", races[statrace].gen[AVERAGE]);
		wprintw(stdscr, "\t(max): %i\n", races[statrace].gen[MAX]);
	}
	return;

}

