#include <curses.h>
#include "bug3.h"

// it seems there may be bugs in some libaries/compilers
// if you bugs repot "this bug is F*****" when DEBUG is 1
// try setting GLITCH to 1 
#define GLITCH 1

void die(struct bug *temp)
{
	population--;
	world[temp->xpos][temp->ypos].contents = CARRION3;
	world[temp->xpos][temp->ypos].food_value = CARRION_FOOD * temp->size;
	world[temp->xpos][temp->ypos].resident = NULL;
	mvwprintw(world_pad, temp->ypos,temp->xpos,"%c",CARRION3);
	refresh();
	if(temp == bugs)
		bugs = bugs->prev;
	if(temp == first)
		first = first->prev;
	if(temp == sb)
		sb = sb->prev;
	if(temp == hg)
		hg = hg->prev;
	if(temp == lp)
		lp = lp->prev;
	if(temp == hp)
		hp = hp->prev;
	if(temp == old)
		old = old->prev;
	temp->prev->next = temp->next;
	temp->next->prev = temp->prev;
	if(bugs == bugs->next)
		stop();
	free(temp);
}

void mate(void)
{
	struct bug *child;
	struct bug *mate;
	struct bug *temp;
	int loop2, val;
	char tempch[3];
	int distance = 1;
	int tmin, tmax;
	char newrace;
	int x,y;

	// where is the mate???
	if(bugs->food < INIT_FOOD * 4) {
		bug_direction (bugs, 0, &x, &y);
		mate = world[x][y].resident;
	}
	else {
		mate = bugs;
	}
	population++;
				
	child = (struct bug *) malloc (sizeof(struct bug));
	
	do {
		child->ypos = -1;
		child->xpos = -1;

		tmin = (bugs->ypos + world_row - getrandom(1, distance)) % world_row;
		tmax = (bugs->ypos + getrandom(1, distance)) % world_row;
		while ((child->ypos < 0)||(child->ypos > world_row))
			child->ypos = tmin < tmax ? getrandom(tmin, tmax) : getrandom(tmax, tmin);

		tmin = (bugs->xpos + world_col - getrandom(1, distance)) % world_col;
		tmax = (bugs->xpos + getrandom(1, distance)) % world_col;
		while ((child->xpos < 0)||(child->xpos > world_col))
			child->xpos = tmin < tmax ? getrandom(tmin, tmax) : getrandom(tmax, tmin);

		distance++;
	} while (world[child->xpos][child->ypos].contents != SPACE || world[child->xpos][child->ypos].resident);

	// new bug race and generation
	if (getrandom (1,100) <= XENOGENESIS) {
		#ifdef DEBUG
		 fprintf (stderr, "Xenogenesis:\n");
		#endif
		child->race = '\0';
		for (newrace=LOW_RACE; newrace<=HIGH_RACE; newrace++) {
			temp = first;
			do {
				if (temp->race == newrace) {
					#ifdef DEBUG
					 fprintf (stderr, "%c used...\n", newrace);
					#endif
					break;
				}
				temp=temp->next;
			} while (temp != first);
			if (temp->race != newrace) {
				#ifdef DEBUG
				 fprintf (stderr, "%c unused, creating new race.\n", newrace);
				#endif
				child->race = newrace;
				break;
			}
		}
		if (child->race == '\0') {
			#ifdef DEBUG
			 fprintf (stderr, "No free races; using parent race (%c).\n", bugs->race);
			#endif
			child->race = bugs->race;
		}
	}
	else {
		child->race = bugs->race;
	}
	child->generation = bugs->generation + 1;
	child->vector = getrandom(0,3);
	child->food = (bugs->food)/3;
	// predlvl is average of parents'
	child->predlvl = (bugs->predlvl + mate->predlvl)/2; 
	// with some standard deviation thrown in
	child->predlvl += (-1 + getrandom (0,2)) * getrandom (0,BUG_PRED);
	child->age = 0;

	// size is average of parents'
	child->size = (bugs->size + mate->size)/2; 
	// with some standard deviation thrown in
	child->size += (-1 + getrandom (0,2)) * getrandom (0,(MAX_SIZE-child->size<child->size-MIN_SIZE)?(MAX_SIZE-child->size+1):(child->size-MIN_SIZE+1));
	if (child->size < MIN_SIZE) child->size = MIN_SIZE;
	if (child->size > MAX_SIZE) child->size = MAX_SIZE;

	// hit points are based strictly on size for now
	child->hit_points = child->size * HP_FACTOR;

	// regen speed is average of parents'
	child->regen_speed = (bugs->regen_speed + mate->regen_speed)/2; 
	// with some standard deviation thrown in
	child->regen_speed += (-1 + getrandom (0,2)) * getrandom (0,(MAX_REGEN-child->regen_speed<child->regen_speed-MIN_REGEN)?(MAX_REGEN-child->regen_speed+1):(child->regen_speed-MIN_REGEN+1));
	if (child->regen_speed < MIN_REGEN) child->regen_speed = MIN_REGEN;
	if (child->regen_speed > MAX_REGEN) child->regen_speed = MAX_REGEN;

	for(loop2 = 0; loop2 <= S_LEN; loop2++)
	{
		switch(getrandom(0,8))
		{
			case 0:
			case 2:
			case 4:
			case 6: 
			case 8:
				// copy parent bugs
				child->search[loop2] = bugs->search[loop2];      
				break;
			case 1:
			case 3:
			case 5:
				// copy parent mate
				child->search[loop2] = mate->search[loop2];      
				break;
			case 7:
				// mutate
				child->search[loop2] = getrandom(0,3);
				break;
			default:
				fprintf(stderr, "default in new genes ...\n");
				break;
		}
		if (child->search[loop2] == 0)
			child->predlvl--;
		if (child->search[loop2] == 3)
			child->predlvl++;
	}
	for (loop2=0; loop2<=255; loop2++) {
		child->food_type [loop2] = 0;
	}
	if (child->predlvl < -BUG_PRED) {
		child->food_type [CARRION3] = 0;
	}
	else {
		child->food_type [CARRION3] = 1;
	}
	if (child->predlvl > BUG_PRED) {
		child->food_type [FOOD3] = 0;
		child->food_type [FOOD23] = 0;
	}
	else {
		child->food_type [FOOD3] = 1;
		child->food_type [FOOD23] = 1;
	}

	child->next = bugs->next;
	bugs->next->prev = child;
	bugs->next = child;
	child->prev = bugs;
	bugs->food = (((bugs->food)*2)/3) - MATE_COST;
	return;
}
