#include <curses.h>
#include "bug3.h"

int isbug(char temp)
{
	if (temp >= LOW_RACE && temp <= HIGH_RACE)
		return(1);
	else
		return(0);
}

int motivate(char temp)
{
	if(((temp == bugs->race)&&(bugs->food > 5 * MATE_COST))||((bugs->food_type[temp])&&(bugs->food < INIT_FOOD * 2)))
		return(1);
	
	if((temp != bugs->race)&&(isbug(temp)))
		return(bugs->predlvl);
	
	return(0);
}

int look(int search)
{
	struct bug *eaten;
	char temp;
	int leftw = 0, rightw = 0, forwardw = 0;
	int ifhit;
	int x,y;
	
	// look for mate and/or food
	#ifdef DEBUG
	 fprintf (stderr, " looking for mate and/or food...\n");
	#endif	
	temp = peek(1,0);
	#ifdef DEBUG
	 fprintf (stderr, " there's a %c there.\n", temp);
	#endif
	if((temp == bugs->race)&&(bugs->food > 5 * MATE_COST))
	{
		#ifdef DEBUG
		 fprintf (stderr, " mate with it!\n");
		#endif
		mate();
		// exausted ...
		return WAIT;
	} 
	
	if(bugs->food_type[temp])
	{
		#ifdef DEBUG
		 fprintf (stderr, " eat it!\n");
		#endif
		placefood();
		bug_direction (bugs, 0, &x, &y);
		bugs->food += world[x][y].food_value;
		world[x][y].contents = SPACE;
		return FORWARD;
	}
	
	#ifdef DEBUG
	 fprintf (stderr, " is it prey?\n");
	#endif
	if((temp != bugs->race)&&(isbug(temp))&&(bugs->predlvl > -BUG_PRED))
	{
		#ifdef DEBUG
		 fprintf (stderr, " it is!\n");
		#endif
		bug_direction (bugs, 0, &x, &y);
		eaten = world[x][y].resident;
		
		ifhit = eaten->predlvl < bugs->predlvl ? getrandom(eaten->predlvl, bugs->predlvl) : getrandom(bugs->predlvl, eaten->predlvl);
		if (ifhit > 0)
		{
			eaten->hit_points -= (BITE_SIZE*bugs->size/eaten->size);
			if (eaten->hit_points <= 0)
			{
				bugs->food += BUG_FOOD*eaten->size;
				bugs->predlvl++;
				if (bugs->predlvl > BUG_PRED) {
					bugs->food_type [FOOD3] = 0;
					bugs->food_type [FOOD23] = 0;
				}
				die(eaten);
			}
			else if (eaten->predlvl < 0) {
				eaten->predlvl--;
			}
		}

		return WAIT;
	}
	
	#ifdef DEBUG
	 fprintf (stderr, " is something sneaking up behind us?\n");
	#endif
	// listen in back for preditor ...
	temp = peek(-1,0);
	if((temp != bugs->race)&&(isbug(temp)))
		forwardw += bugs->predlvl * 2;
	temp = peek(-2,0);
	if((temp != bugs->race)&&(isbug(temp)))
		forwardw += bugs->predlvl;
	temp = peek(-1,1);
	if((temp != bugs->race)&&(isbug(temp)))
		forwardw += bugs->predlvl;
	temp = peek(-1,-1);
	if((temp != bugs->race)&&(isbug(temp)))
		forwardw += bugs->predlvl;
	// end listen ...

	#ifdef DEBUG
	 fprintf (stderr, " Now we're doing stuff I don't understand at all!\n");
	#endif
	temp = peek(1,0);
	if(temp == SPACE)
	{       
		temp = peek(2,0);
		forwardw += motivate(temp);

		if(temp == SPACE)
		{       
			temp = peek(3,0);
			forwardw += motivate(temp);

			temp = peek(2,-1);
			forwardw += motivate(temp);

			temp = peek(2,1);
			forwardw += motivate(temp);
		}
		
		temp = peek(1,-1);
		forwardw += motivate(temp);

		temp = peek(1,-1);
		forwardw += motivate(temp);
	}
			
	temp = peek(0,-1);
	leftw += motivate(temp);

	if(temp == SPACE)
	{
		temp = peek(0,-2);
		leftw += motivate(temp);
		
		if(temp == SPACE)
		{
			temp = peek(0,-3);
			leftw += motivate(temp);
		
			temp = peek(1,-2);
			leftw += motivate(temp);
		}

		temp = peek(1,-1);
		leftw += motivate(temp);
	}
	
	temp = peek(0,1);
	rightw += motivate(temp);

	if(temp == SPACE)
	{
		temp = peek(0,2);
		rightw += motivate(temp);

		if(temp == SPACE)
		{
			temp = peek(0,3);
			rightw += motivate(temp);

			temp = peek(1,2);
			rightw += motivate(temp);
		}

		temp = peek(1,1);
		rightw += motivate(temp);
	}
	
	temp = peek(1,0);

	if((leftw)||(rightw)||(forwardw))	
	{
		// forward > left & right
		if((forwardw > leftw)&&(forwardw > rightw))
	        	if((forwardw > 0)&&(temp == SPACE))
        	        	return FORWARD;
	                else 
        	        	if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
        				return bugs->search[search];
        	        	else
	        	        	return getrandom(LEFT,RIGHT);

		// left > forward & right
		if((leftw > rightw)&&(leftw > forwardw))
	        	if(leftw > 0)
        	        	return LEFT;
	                else if(temp == SPACE)
        	        	if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
        	        		return bugs->search[search];
				else
	        	        	return getrandom(RIGHT, FORWARD);
			else
				return RIGHT;

		// right > left & forward
		if((rightw > leftw)&&(rightw > forwardw))
	        	if(rightw > 0)
        	        	return RIGHT;
			else if (temp == SPACE)
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			else 
				return LEFT;
			
		// left & right > forward
		if((leftw == rightw)&&(rightw > forwardw))
	        	if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
	        		return bugs->search[search];
	        	else
	        		return getrandom(LEFT,RIGHT);

		// forward & right > left
		if((forwardw == rightw)&&(rightw > leftw))
                	if(temp == SPACE)
				if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return getrandom(RIGHT,FORWARD);
			else
				return RIGHT;
			
		// forward & left > right
		if((forwardw == leftw)&&(leftw > rightw))
                	if(temp == SPACE)
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			else
				return LEFT;

		// all equil
        	if(temp == SPACE)
        		if(bugs->search[search] == WAIT)
        			return getrandom(LEFT, FORWARD);
        		else
        			return bugs->search[search];
		else
			if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
				return bugs->search[search];
			else
				return getrandom(LEFT, RIGHT);
	}

	// default din't see anything good ...
	if((temp != SPACE)&&(bugs->search[search] == FORWARD))
		return getrandom(WAIT, RIGHT);

	#ifdef DEBUG
	 fprintf (stderr, " Nothing interesting... we just fell all the way through.\n");
	#endif
	return bugs->search[search];
}

char peek(int fw, int lr)
{
	int x,y;
	switch(bugs->vector)
	{
		case 0:
			y = (bugs->ypos + world_row - fw) % world_row;
			x = (bugs->xpos + world_col + lr) % world_col;
			break;
		case 1:
			y = (bugs->ypos + world_row + lr) % world_row;
			x = (bugs->xpos + world_col + fw) % world_col;
			break;
		case 2:
			y = (bugs->ypos + world_row + fw) % world_row;
			x = (bugs->xpos + world_col - lr) % world_col;
			break;
		case 3:
			y = (bugs->ypos + world_row - lr) % world_row;
			x = (bugs->xpos + world_col - fw) % world_col;
			break;
		default:
			fprintf(stderr,"default in peek bugs->vector is bad\n");
			break;   
	}
	if (world[x][y].resident) {
		return world[x][y].resident->race;
	}
	else {
		return world[x][y].contents;
	}
}

void bug_direction (struct bug *bug, int direction, int *x, int *y)
{
	// find coordinates of square in front of bug
	switch( (bugs->vector + direction) % 4 )
	{
		case 0:
			// screen up
			*y = (bug->ypos - 1 + world_row) % world_row;
			*x = bug->xpos;
			break;
		case 1:
			// screen right
			*y = bugs->ypos;
			*x = (bugs->xpos + 1) % world_col;
			break;
		case 2:
			// screen down
			*y = (bugs->ypos + 1) % world_row;
			*x = bugs->xpos;
			break;
		case 3: 
			// screen left
			*y = bugs->ypos;
			*x = (bugs->xpos - 1 + world_col) % world_col;
			break;                                          
		default:
			fprintf(stderr, "default in bug_direction is mathematically impossible... congratulations\n");
			break;
	}
}
