// Bug3 header file
#ifndef BUG3_H
#define BUG3_H 

#define getrandom( min, max ) ((rand() % (int) (((max) + 1) - (min))) + (min))

// size of world
//#define world_col (int)(COLS * 5)
//#define world_row (int)(LINES * 5)
#define world_col 400
#define world_row 125

// used to set intial condition in start() ...
//#define NUM_BLOCKS (world_col * world_row * .05)
#define NUM_BLOCKS 0
#define NUM_FOOD (world_col * world_row * .1)
#define NUM_BUGS (world_col * world_row * .01)

#define HEIGHT 1
#define ROUGHNESS 1
#define SEA_LEVEL -1
#define GRID_SIZE 32

// how much food to start with
#define INIT_FOOD 5000

// what races?
#define LOW_RACE 'A'
#define HIGH_RACE 'T'

// critter sizes
#define MIN_SIZE 1
#define MAX_SIZE 9
// number of hp per size level
#define HP_FACTOR 10
// number of food burned to regen one hp
#define REGEN_FACTOR 10
// limits on regeneration rate
#define MIN_REGEN MIN_SIZE
#define MAX_REGEN MAX_SIZE
 

// percent chance that a newborn bug will be a different species than its parents
#define XENOGENESIS 1

// how many food are used for various actions ...
#define WAIT_COST 1
#define TURN_COST 3
#define MOVE_COST 10
#define MATE_COST 1000

// how wide is the omnivore window?
#define BUG_PRED 5
// how much a preditor gets for eating a bug ...
#define BUG_FOOD 500
#define FOOD_FOOD 150
#define CARRION_FOOD 50
// how much does it hurt the bug ???
#define BITE_SIZE 5

// search legnth ... how many genes in the DNA ...
#define S_LEN 25 

// things bugs might see ...
#define FOOD1 '.'
#define FOOD2 '*'
#define FOOD3 '@'
#define FOOD21 ','
#define FOOD22 '+'
#define FOOD23 '0'
#define SPACE ' '
#define BLOCK '#'
#define WATER '~'
#define CARRION1 '\''
#define CARRION2 ':'
#define CARRION3 '%'

// FOOD_RATE min = 1 ... higher = slower ... 1 = always ...
#define FOOD_RATE 10
// percent chance that mature food will spread to an adjacent square
#define SPREAD_CHANCE 75

// a bug does what ???
#define WAIT 0
#define LEFT 1
#define RIGHT 2
#define FORWARD 3

// the bug structure
struct bug
{
	int xpos, ypos, vector;  
	int food;
	char food_type [255];
	int predlvl;
	char race;
	int size;
	int hit_points;
	int regen_speed;
	int age;
	int generation;
	int search[S_LEN];
	struct bug *prev;
	struct bug *next;
};

struct square
{
	int elevation;
	char contents;
	int food_value;
	struct bug *resident;
};

// current & "first"
struct bug *bugs, *first;

// status, highfood, high gen, oldest bugs ...
struct bug *sb, *hf, *hg, *old, *hp, *lp;

// population counter
int population;

// world_pad "the world"
WINDOW *world_pad;
// world... the *real* world, independent of current display
struct square world[world_col][world_row];

// init ...
void init (void);

// set intial screen ...
void start(void);

// end program ...
void stop(void);

// the main function ...
// examine environment dicide what to do ...
int look(int);

// reproduce ...
void mate(void);
// with who ???
struct bug* findbug(int y, int x);

// poor bug ... rest in piece ...
void die(struct bug* temp);

// what a bug sees here ...
char peek(int fw, int lr);

// the coordinates of the square in a particular direction relative to a bug
void bug_direction (struct bug *bug, int direction, int *x, int *y);

// food growth ...
void growfood(void);
void placefood(void);

// edit bug race ... DNA
void edit(struct bug *eb);

// cataclysmic geological forces shaping the landscape
void generateterrain (void);

#endif /* BUG3_H */
