#include <curses.h>
#include "bug3.h"

#define NUM_XPMD 92
char xpm_digits[NUM_XPMD] = " .+@#$%&*=-;>,\')!~{]^/(_:<[}|1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`";

void generateterrain (void)
{
	int elevation_map [world_col][world_row];
	int grid_size = GRID_SIZE;
	int x;
	int y;
	
	#ifdef DEBUG
	 fprintf (stderr, "Generating primary grid...\n");
	#endif
	/* define primary grid */
	for (x=0; x<world_col; x+=grid_size) {
		for (y=0; y<world_row; y+=grid_size) {
			elevation_map[x][y] = getrandom (0,HEIGHT);
		}
	}

	for (grid_size/=2; grid_size >= 1; grid_size/=2) {	
		#ifdef DEBUG
		 fprintf (stderr, "Reticulating splines (grid size %i)...\n", grid_size);
		 fprintf (stderr, "Interpolating horizontally...\n");
		#endif
		/* interpolate smaller grid along horizontals */
		for (x=grid_size; x<world_col; x+=grid_size*2) {
			for (y=0; y<world_row; y+=grid_size*2) {
				elevation_map[x][y] = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (elevation_map[x-grid_size][y] + elevation_map[(x+grid_size<world_col)?(x+grid_size):(0)][y])/2;
			}
		}
		#ifdef DEBUG
		 fprintf (stderr, "Interpolating vertically...\n");
		#endif
		/* interpolate smaller grid along verticals */
		for (x=0; x<world_col; x+=grid_size*2) {
			for (y=grid_size; y<world_row; y+=grid_size*2) {
				elevation_map[x][y] = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (elevation_map[x][y-grid_size] + elevation_map[x][(y+grid_size<world_row)?(y+grid_size):(0)])/2;
			}
		}
		#ifdef DEBUG
		 fprintf (stderr, "Interpolating centerpoints...\n");
		#endif
		/* interpolate smaller grid between gridlines */
		for (x=grid_size; x<world_col; x+=grid_size*2) {
			for (y=grid_size; y<world_row; y+=grid_size*2) {
				elevation_map[x][y] = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (elevation_map[x][y-grid_size] + elevation_map[x][(y+grid_size<world_row)?(y+grid_size):(0)] + elevation_map[(x+grid_size<world_col)?(x+grid_size):(0)][y] + elevation_map[x-grid_size][y])/4;
			}
		}
	}

	for (x=0; x<world_col; x++) {
		for (y=0; y<world_row; y++) {
			if (elevation_map[x][y] < SEA_LEVEL) {
				mvwprintw(world_pad, y, x,"%c",WATER);
			}
		}
	}

}	

void printxpm (void)
{
	int i, x, y, z;
	char temp[3];
	int val;
	FILE *snapshot;
	if (snapshot = fopen ("bug.xpm", "wb") ) {
		fprintf (snapshot, "/* XPM */\nstatic char * bugs_xpm[] = {\n");
		fprintf (snapshot, "\"%i %i %i 2\",\n", world_col, world_row, 8);
		fprintf (snapshot, "\"%c%c     c #886600\",\n", xpm_digits[0%NUM_XPMD], xpm_digits[0/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #0000FF\",\n", xpm_digits[1%NUM_XPMD], xpm_digits[1/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #CCCCCC\",\n", xpm_digits[2%NUM_XPMD], xpm_digits[2/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #FFFFFF\",\n", xpm_digits[3%NUM_XPMD], xpm_digits[3/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #000000\",\n", xpm_digits[4%NUM_XPMD], xpm_digits[4/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #00FF00\",\n", xpm_digits[5%NUM_XPMD], xpm_digits[5/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c #008800\",\n", xpm_digits[6%NUM_XPMD], xpm_digits[6/NUM_XPMD]);
		fprintf (snapshot, "\"%c%c     c none\",\n", xpm_digits[7%NUM_XPMD], xpm_digits[7/NUM_XPMD]);
		for (y=0; y<world_row; y++) {
			fprintf (snapshot, "\"");
			for (x=0; x<world_col; x++) {
				val = mvwinnstr(world_pad,y,x,temp,1);
				if (temp[0] == SPACE) {
					fprintf (snapshot, "%c%c", xpm_digits [0%NUM_XPMD], xpm_digits [0/NUM_XPMD]);
				}
				else if (temp[0] == WATER) {
					fprintf (snapshot, "%c%c", xpm_digits [1%NUM_XPMD], xpm_digits [1/NUM_XPMD]);
				} 
				else if (temp[0] == BLOCK) {
					fprintf (snapshot, "%c%c", xpm_digits [2%NUM_XPMD], xpm_digits [2/NUM_XPMD]);
				}
				else if ( isbug(toupper(temp[0])) ) {
					fprintf (snapshot, "%c%c", xpm_digits [3%NUM_XPMD], xpm_digits [3/NUM_XPMD]);
				}
				else if ( temp[0]==CARRION1 || temp[0]==CARRION2 || temp[0]==CARRION3 ) {
					fprintf (snapshot, "%c%c", xpm_digits [4%NUM_XPMD], xpm_digits [4/NUM_XPMD]);
				}
				else if ( temp[0]==FOOD1 || temp[0]==FOOD2 || temp[0]==FOOD3 ) {
					fprintf (snapshot, "%c%c", xpm_digits [5%NUM_XPMD], xpm_digits [5/NUM_XPMD]);
				}
				else if ( temp[0]==FOOD21 || temp[0]==FOOD22 || temp[0]==FOOD23 ) {
					fprintf (snapshot, "%c%c", xpm_digits [6%NUM_XPMD], xpm_digits [6/NUM_XPMD]);
				}
				else {
					fprintf (snapshot, "%c%c", xpm_digits [7%NUM_XPMD], xpm_digits [7/NUM_XPMD]);
				}
	
			}
			if (y == world_row-1) {
				fprintf (snapshot, "\"};\n");
			}
			else {
				fprintf (snapshot, "\",\n");
			}
		}
		fclose (snapshot);
	}
}

