#include <curses.h>
#include "bug3.h"

void init(void)
{
	initscr();
	init_kb();
	srand((unsigned) time ( NULL ));
	world_pad = newpad(world_row, world_col);
	clear();
	start();
}

void start(void)
{
	struct bug *temp, *x;
	int loop, loop2;

	// generate underlying terrain
	generateterrain();

	// place blocks ..
	for(loop = 1; loop <= NUM_BLOCKS; loop++) {
		mvwprintw(world_pad, getrandom(0,world_row-1),getrandom(0,world_col-1),"%c",BLOCK);
	}
	
	// place food
	for(loop = 1; loop <= NUM_FOOD; loop++)
		placefood();
	
	// create bugs
	for(loop = 1; loop <= NUM_BUGS; loop++)
	{
		population++;
		temp = (struct bug *) malloc (sizeof(struct bug));
		temp->xpos = getrandom(0,world_col-1);
		temp->ypos = getrandom(0,world_row-1);
		temp->vector = getrandom(0,3);
		temp->food = INIT_FOOD;
		for (loop2=0; loop2<=255; loop2++) {
			temp->food_type [loop2] = 0;
		}
		temp->predlvl = 0;
		temp->size = getrandom (MIN_SIZE, MAX_SIZE);
		temp->hit_points = temp->size * HP_FACTOR;
		temp->regen_speed = getrandom(MIN_REGEN, MAX_REGEN);
		temp->race = (char) getrandom(LOW_RACE,HIGH_RACE);
		temp->generation = 1;
		temp->age = 0;
		for(loop2 = 0; loop2 <= S_LEN; loop2++)
		{
			temp->search[loop2] = getrandom(0,3);
			if (temp->search[loop2] == 0)
				temp->predlvl--;
			if (temp->search[loop2] == 3)
				temp->predlvl++;
		}
		if (temp->predlvl < -BUG_PRED) {
			temp->food_type [CARRION3] = 0;
		}
		else {
			temp->food_type [CARRION3] = 1;
		}
		if (temp->predlvl > BUG_PRED) {
			temp->food_type [FOOD3] = 0;
			temp->food_type [FOOD23] = 0;
		}
		else {
			temp->food_type [FOOD3] = 1;
			temp->food_type [FOOD23] = 1;
		}
		if(loop == 1)
			bugs = temp;
		else
		{
			x->next = temp;
			temp->prev = x;
		}
		x = temp;
	}
	temp->next = bugs;
	bugs->prev = temp;
	return;
}

void stop(void)
{
	delwin(world_pad);
	close_kb();
	endwin();
	exit(0);
}
