#include <curses.h>
#include "bug3.h"

void generateterrain (void)
{
	int elevation_map [world_col][world_row];
	int grid_size = 8;
	int x;
	int y;
	// define primary 8-square grid
	for (x=0; x<world_col; x+=grid_size) {
		for (y=0; y<world_row; y+=grid_size) {
			elevation_map[x][y] = getrandom (0,HEIGHT);
		}
	}

	for (grid_size = 4; grid_size >= 1; grid_size/=2) {	
		// interpolate smaller grid along horizontals
		for (x=grid_size; x<world_col; x+=grid_size*2) {
			for (y=0; y<world_row; y+=grid_size*2) {
				elevation_map[x][y] = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (elevation_map[x-grid_size][y] + elevation_map[x+grid_size][y])/2;
			}
		}
		// interpolate smaller grid along verticals
		for (x=0; x<world_col; x+=grid_size*2) {
			for (y=grid_size; y<world_row; y+=grid_size*2) {
				elevation_map[x][y] = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (elevation_map[x][y-grid_size] + elevation_map[x][y+grid_size])/2;
			}
		}
		// interpolate smaller grid between gridlines
		for (x=grid_size; x<world_col; x+=grid_size*2) {
			for (y=grid_size; y<world_row; y+=grid_size*2) {
				elevation_map[x][y] = getrandom (-ROUGHNESS*grid_size,ROUGHNESS*grid_size) + (elevation_map[x][y-grid_size] + elevation_map[x][y+grid_size] + elevation_map[x+grid_size][y] + elevation_map[x-grid_size][y])/4;
			}
		}
	}
	
	for (x=0; x<world_col; x++) {
		for (y=0; y<world_row; y++) {
			if (elevation_map[x][y] < SEA_LEVEL) {
				mvwprintw(world_pad, y, x,"%c",WATER);
			}
		}
	}
}
