#include <curses.h>
#include "bug3.h"

int main()
{
	int temp;
	int ch = 0;
	int dm = 0;
	int search = 0;
	char *sbis = "xx \0";
	WINDOW *stat_bar;
	int pad_col = 0;
	int pad_row = 0;
	char msg[80];
	int pf = 0;

	// this is to slow down the bugs ... higher is slower
	int cpuwait = 1;
	
	init();
	stat_bar = newwin(1, COLS, LINES-1, 0);

	first = bugs;
	sb = bugs;
	hf = bugs;
	hg = bugs;
	old = bugs;
	lp = bugs;
	hp = bugs;
	
	// while bugs do meet taget ... 1000 gen ... 200 food ... ect
	// 1 = just run for ever no target
	while(1)
	{
		// first bug in loop better check out some stuff
		if(bugs == first)
		{
			// be nice to the processor
			if (cpuwait)
				usleep(cpuwait);

			// refresh the display
			if (dm == 0)
				prefresh(world_pad,pad_row,pad_col,0,0,LINES-2,COLS-1);
			else
			{
				stat();
				wrefresh(stdscr);
			}
	
			// show status bar
			mvwprintw(stat_bar, 0, 0, "x 123456 vdcegz hjkl fstpn  %s  %i  ",sbis,population);
			wrefresh(stat_bar);
	
			// next "gene"
			search = ++search % S_LEN;

			// user did what ???
			if (kb_hit()||(ch == 'n')||(ch == 'N'))
			{
				// are we paused???
				do
				{
					if (kb_hit())
						ch = read_kb();
					else if ((ch = 'n')||(ch == 'N'))
						ch = '\0';
						
					switch(ch)
					{
						case 'z': // show stats
						case 'Z':
							dm = !dm;
							break;
						case 'e': // edit race & DNA
						case 'E':
							edit(sb);
							break;
						case 'c': // show sb counts
						case 'C':
							sprintf(msg,"R=%c G=%i A=%i F=%i P=%i S=%i H=%i(%i)",sb->race,sb->generation,sb->age,sb->food,sb->predlvl,sb->size,sb->hit_points,sb->regen_speed);
							dopopup(msg, 3);
							break;
						case 'd': // show DNA of sb
						case 'D':
							for(temp = 0; temp < S_LEN; temp++)
								sprintf(&msg[temp],"%i",sb->search[temp]);
							dopopup(msg, 5);
							break;
						case 'v': // view pos of sb
						case 'V':
							sprintf(msg,"x=%i  y=%i", sb->xpos, sb->ypos);
							dopopup(msg, 2);
							break;
						case '1': // make sb = next
							sbis = "xx \0";
							sb = sb->next;
							break;
						case '2': // make sb = high food
							sbis = "hf \0";
							sb = hf;
							break;
						case '3': // make sb = high gen
							sbis = "hg \0";
							sb = hg;
							break;
						case '4': // make sb = oldest
							sbis = "old\0";
							sb = old;
							break;
						case '5': // make sb = low pred
							sbis = "lp \0";
							sb = lp;
							break;
						case '6': // make sb = high pred
							sbis = "hp \0";
							sb = hp;
							break;
						case 'g': // snap screen to sb
						case 'G':
							pad_row = sb->ypos - ((LINES - 1) / 2);
							if (pad_row < 0)
								pad_row = 0;
							if (pad_row > (world_row - LINES + 1))
								pad_row = world_row - LINES + 1;
							pad_col = sb->xpos - (COLS / 2);
							if (pad_col < 0)
								pad_col = 0;
							if(pad_col > (world_col - COLS))
								pad_col = world_col - COLS;
							break;
						case 'h': // move screen left
						case 'H':
							if (pad_col > 0)
								pad_col--;
							break;
						case 'j': // move screen down
						case 'J':
							if (pad_row < (world_row - LINES + 1))
								pad_row++;
							break;
						case 'k': // move screen up
						case 'K':
							if (pad_row > 0)	
								pad_row--;
							break;
						case 'l': // move screen right
						case 'L':
							if (pad_col < (world_col - COLS))
								pad_col++;
							break;
						case 'x': // exit	
						case 'X':
							stop();
							break;
						case 'f': // faster
						case 'F':
							if(cpuwait <= 1)
								cpuwait = 0;
							else
								cpuwait /= 2;
							sprintf(msg,"speed=%i", cpuwait);
							dopopup(msg, 1);
							pf = 0;
							break;
						case 's': // slower
						case 'S':
							if(cpuwait == 0)
								cpuwait = 1;
							else
								cpuwait *= 2;
							sprintf(msg,"speed=%i", cpuwait);
							dopopup(msg, 1);
							pf = 0;
							break;					
						case 't': // turbo fast as can go
						case 'T':
							cpuwait = 0;
							sprintf(msg,"speed=%i", cpuwait);
							dopopup(msg, 1);
							pf = 0;
							break;
						case 'p': // pause
						case 'P':
							dopopup("Pause", 1);
							ch = '\0';
							pf = !pf;
							break;
						case '\0': // update when paused
							// refresh the display
							if (dm == 0)
								prefresh(world_pad,pad_row,pad_col,0,0,LINES-2,COLS-1);
							else
							{
								stat();
								wrefresh(stdscr);
							}
							// show status bar
							mvwprintw(stat_bar, 0, 0, "x 123456 vdcegz hjkl fstpn  %s  %i  ",sbis,population);
							wrefresh(stat_bar);
							usleep(100000);
							break;	
						case 'n': // single step
						case 'N':
							dopopup("Single step",1);
							pf = !0;
							break;
						default: // user hit unused key
							dopopup("bad key",1);
							break;
					} // clsose swtich()
				} // pasued???
				while (pf&&(ch != 'n')&&(ch != 'N'));
			} // done with user
		} // end first bug
		
		// start of DNA check some other stuff
		if(search == 0)
		{
			// get older
			bugs->age++;

// 			Why the --?			
//			if(--bugs->food <= 0)
			// is bug starving?
			if(bugs->food <= 0)
			{
				bugs->hit_points -= bugs->size;
			}
			
			// did bug die?
			if (bugs->hit_points <= 0)
				die(bugs);
				
			// did bug eat lots???
			if(bugs->food >= INIT_FOOD * 4)
			{
				mate();
				bugs->food /= 5;
			}
			
			// grow some food
			if(bugs == first)
				growfood();
		
			// keep track of special bugs
			if (bugs->food > hf->food)
				hf = bugs;

			if (bugs->predlvl < lp->predlvl)
				lp = bugs;

			if (bugs->predlvl > hp->predlvl)
				hp = bugs;

			if (bugs->generation > hg->generation)
				hg = bugs;

			if (bugs->age > old->age)
				old = bugs;
		} // end of other stuff
			
		bugs = bugs->next;
		mvwprintw(world_pad, bugs->ypos,bugs->xpos," ");

		// what is bug doing???
		switch(look(search))
		{
			case WAIT: // do nothing
				bugs->food -= WAIT_COST * bugs->size;
				// if we're just sitting around, we can heal
				if (bugs->hit_points < bugs->size * HP_FACTOR && bugs->food >= bugs->regen_speed)
				{
					bugs->food -= bugs->regen_speed * REGEN_FACTOR;
					bugs->hit_points += bugs->regen_speed;
					if (bugs->hit_points > bugs->size * HP_FACTOR)
						bugs->hit_points = bugs->size * HP_FACTOR;
				}
				break;
			case LEFT: // turn left
				bugs->food -= TURN_COST * bugs->size;
				bugs->vector = (--bugs->vector + 4) % 4;        
				break;
			case RIGHT: // turn right
				bugs->food -= TURN_COST * bugs->size;
				bugs->vector = ++bugs->vector % 4;
				break;
			case FORWARD: // move ahead
				bugs->food -= MOVE_COST * bugs->size;
				switch(bugs->vector)
				{
					case 0:	// screen up
						bugs->ypos = (--bugs->ypos + world_row) % world_row;
						break;
					case 1: // screen right
						bugs->xpos = (++bugs->xpos) % world_col;
						break;
					case 2: //screen down
						bugs->ypos = (++bugs->ypos) % world_row;
						break;
					case 3: // screen left
						bugs->xpos = (--bugs->xpos + world_col) % world_col;
						break;                                          
					default:
						fprintf(stderr, "default in main inner bugs->vector is bad\n");
						break;
				}
				break;
			default:
				fprintf(stderr, "default in main look returned a bad value\n");
				break;
		} // bug done
		if (bugs->predlvl > 0) wattron (world_pad, WA_STANDOUT);
		mvwprintw(world_pad, bugs->ypos,bugs->xpos,"%c",(bugs->size<5)?(tolower(bugs->race)):(bugs->race));
		if (bugs->predlvl > 0) wattroff (world_pad, WA_STANDOUT);
	}
	// exit from main while loop ... 
	fprintf(stderr,"exited from main while loop ... goal met ...\n");
	stat();
	stop();
}
