#include <curses.h>
#include "bug3.h"

int isbug(char temp)
{
	if ((temp == FOOD1)||(temp == FOOD2)||(temp == FOOD3)||(temp == BLOCK)||(temp == SPACE))
		return(0);
	else
		return(1);
}

int motivate(char temp)
{
	if(((temp == bugs->race)&&(bugs->food > INIT_FOOD + MATE_COST))||((temp == bugs->food_type)&&(bugs->food < INIT_FOOD * 2)))
		return(1);
	
	if((temp != bugs->race)&&(isbug(temp)))
		return(bugs->predlvl);
	
	return(0);
}

int look(int search)
{
	struct bug *eaten;
	char temp;
	int leftw = 0, rightw = 0, forwardw = 0;
	int ifhit;
	
	// look for mate and/or food
	
	temp = peek(1,0);
	if((temp == bugs->race)&&(bugs->food > INIT_FOOD + MATE_COST))
	{
		mate();
		// exausted ...
		return WAIT;
	} 
	
	if(temp == bugs->food_type)
	{
		placefood();  
		bugs->food += FOOD_FOOD;
		return FORWARD;
	}
	
	if((temp != bugs->race)&&(isbug(temp))&&(bugs->predlvl > -BUG_PRED))
	{
		switch(bugs->vector)
		{
			case 0:
				// screen up
				eaten = findbug((bugs->ypos - 1 + world_row) % world_row,bugs->xpos);
				break;
			case 1:
				// screen right
				eaten = findbug(bugs->ypos,(bugs->xpos + 1) % world_col);
				break;
			case 2:
				// screen down
				eaten = findbug((bugs->ypos + 1) % world_row,bugs->xpos);
				break;
			case 3: 
				// screen left
				eaten = findbug(bugs->ypos,(bugs->xpos - 1 + world_col) % world_col);
				break;                                          
			default:
				fprintf(stderr, "default in perditor eat bugs->vector is bad\n");
				break;
		}
		
		ifhit = eaten->predlvl < bugs->predlvl ? getrandom(eaten->predlvl, bugs->predlvl) : getrandom(bugs->predlvl, eaten->predlvl);
		if (ifhit > 0)
		{
			eaten->hit_points -= (BITE_SIZE*bugs->size/eaten->size);
			if (eaten->hit_points <= 0)
			{
				bugs->food += BUG_FOOD*eaten->size;
				bugs->predlvl++;
				if (bugs->predlvl > BUG_PRED)
					bugs->food_type = '\0';
				die(eaten);
			}
			else if (eaten->predlvl < 0)
				eaten->predlvl--;
		}

		return WAIT;
	}
	
	// listen in back for preditor ...
	temp = peek(-1,0);
	if((temp != bugs->race)&&(isbug(temp)))
		forwardw += bugs->predlvl * 2;
	temp = peek(-2,0);
	if((temp != bugs->race)&&(isbug(temp)))
		forwardw += bugs->predlvl;
	temp = peek(-1,1);
	if((temp != bugs->race)&&(isbug(temp)))
		forwardw += bugs->predlvl;
	temp = peek(-1,-1);
	if((temp != bugs->race)&&(isbug(temp)))
		forwardw += bugs->predlvl;
	// end listen ...

	temp = peek(1,0);
	if(temp == SPACE)
	{       
		temp = peek(2,0);
		forwardw += motivate(temp);

		if(temp == SPACE)
		{       
			temp = peek(3,0);
			forwardw += motivate(temp);

			temp = peek(2,-1);
			forwardw += motivate(temp);

			temp = peek(2,1);
			forwardw += motivate(temp);
		}
		
		temp = peek(1,-1);
		forwardw += motivate(temp);

		temp = peek(1,-1);
		forwardw += motivate(temp);
	}
			
	temp = peek(0,-1);
	leftw += motivate(temp);

	if(temp == SPACE)
	{
		temp = peek(0,-2);
		leftw += motivate(temp);
		
		if(temp == SPACE)
		{
			temp = peek(0,-3);
			leftw += motivate(temp);
		
			temp = peek(1,-2);
			leftw += motivate(temp);
		}

		temp = peek(1,-1);
		leftw += motivate(temp);
	}
	
	temp = peek(0,1);
	rightw += motivate(temp);

	if(temp == SPACE)
	{
		temp = peek(0,2);
		rightw += motivate(temp);

		if(temp == SPACE)
		{
			temp = peek(0,3);
			rightw += motivate(temp);

			temp = peek(1,2);
			rightw += motivate(temp);
		}

		temp = peek(1,1);
		rightw += motivate(temp);
	}
	
	temp = peek(1,0);

	if((leftw)||(rightw)||(forwardw))	
	{
		// forward > left & right
		if((forwardw > leftw)&&(forwardw > rightw))
	        	if((forwardw > 0)&&(temp == SPACE))
        	        	return FORWARD;
	                else 
        	        	if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
        				return bugs->search[search];
        	        	else
	        	        	return getrandom(LEFT,RIGHT);

		// left > forward & right
		if((leftw > rightw)&&(leftw > forwardw))
	        	if(leftw > 0)
        	        	return LEFT;
	                else if(temp == SPACE)
        	        	if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
        	        		return bugs->search[search];
				else
	        	        	return getrandom(RIGHT, FORWARD);
			else
				return RIGHT;

		// right > left & forward
		if((rightw > leftw)&&(rightw > forwardw))
	        	if(rightw > 0)
        	        	return RIGHT;
			else if (temp == SPACE)
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			else 
				return LEFT;
			
		// left & right > forward
		if((leftw == rightw)&&(rightw > forwardw))
	        	if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
	        		return bugs->search[search];
	        	else
	        		return getrandom(LEFT,RIGHT);

		// forward & right > left
		if((forwardw == rightw)&&(rightw > leftw))
                	if(temp == SPACE)
				if((bugs->search[search] == RIGHT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return getrandom(RIGHT,FORWARD);
			else
				return RIGHT;
			
		// forward & left > right
		if((forwardw == leftw)&&(leftw > rightw))
                	if(temp == SPACE)
				if((bugs->search[search] == LEFT)||(bugs->search[search] == FORWARD))
					return bugs->search[search];
				else
					return (getrandom(0,1) ? LEFT : FORWARD);
			else
				return LEFT;

		// all equil
        	if(temp == SPACE)
        		if(bugs->search[search] == WAIT)
        			return getrandom(LEFT, FORWARD);
        		else
        			return bugs->search[search];
		else
			if((bugs->search[search] == LEFT)||(bugs->search[search] == RIGHT))
				return bugs->search[search];
			else
				return getrandom(LEFT, RIGHT);
	}

	// default din't see anything good ...
	if((temp != SPACE)&&(bugs->search[search] == FORWARD))
		return getrandom(WAIT, RIGHT);

	return bugs->search[search];
}

char peek(int fw, int lr)
{
	int val;
	char temp[3];
	
	switch(bugs->vector)
	{
		case 0:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - fw) % world_row,(bugs->xpos + world_col + lr) % world_col,temp,1);
			break;
		case 1:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + lr) % world_row,(bugs->xpos + world_col + fw) % world_col,temp,1);
			break;
		case 2:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row + fw) % world_row,(bugs->xpos + world_col - lr) % world_col,temp,1);
			break;
		case 3:
			val = mvwinnstr(world_pad,(bugs->ypos + world_row - lr) % world_row,(bugs->xpos + world_col - fw) % world_col,temp,1);
			break;
		default:
			fprintf(stderr,"default in peek bugs->vector is bad\n");
			break;   
	}
	return toupper(temp[0]);
}
