#include <curses.h>
#include "bug3.h"

#define AVERAGE 0
#define MIN 1
#define MAX 2

struct counts
{ 
	int pop;
	int age [3];
	int food [3];
	int gen [3];
	int pred [3];
	int size [3]; 
};

void init_counts (struct counts *temp)
{
	temp->pop = 0;
	temp->age[MIN] = 0xFFFF;
	temp->food[MIN] = 0xFFFF;
	temp->gen[MIN] = 0xFFFF;
	temp->pred[MIN] = 0xFFFF;	
	temp->size[MIN] = 0xFFFF;
	temp->age[AVERAGE] = 0;
	temp->food[AVERAGE] = 0;
	temp->gen[AVERAGE] = 0;
	temp->pred[AVERAGE] = 0;	
	temp->size[AVERAGE] = 0;
	temp->age[MAX] = -0xFFFF;
	temp->food[MAX] = -0xFFFF;
	temp->gen[MAX] = -0xFFFF;
	temp->pred[MAX] = -0xFFFF;	
	temp->size[MAX] = -0xFFFF;
	return;
}

void stat(void)
{
	struct bug *tempbug = bugs;
	struct counts races[256];
	int temp;
	
	clear();
	for(temp = 0;temp < 256;temp++)
		init_counts(&races[temp]);
	
	while(races[0].pop < population)
	{
		races[0].age[AVERAGE] += tempbug->age;
		if (tempbug->age < races[0].age[MIN]) races[0].age[MIN] = tempbug->age;
		if (tempbug->age > races[0].age[MAX]) races[0].age[MAX] = tempbug->age;
		races[0].food[AVERAGE] += tempbug->food;
		if (tempbug->food < races[0].food[MIN]) races[0].food[MIN] = tempbug->food;
		if (tempbug->food > races[0].food[MAX]) races[0].food[MAX] = tempbug->food;
		races[0].gen[AVERAGE] += tempbug->generation;
		if (tempbug->generation < races[0].gen[MIN]) races[0].gen[MIN] = tempbug->generation;
		if (tempbug->generation > races[0].gen[MAX]) races[0].gen[MAX] = tempbug->generation;
		races[0].pred[AVERAGE] += tempbug->predlvl;
		if (tempbug->predlvl < races[0].pred[MIN]) races[0].pred[MIN] = tempbug->predlvl;
		if (tempbug->predlvl > races[0].pred[MAX]) races[0].pred[MAX] = tempbug->predlvl;
		races[0].size[AVERAGE] += tempbug->size;
		if (tempbug->size < races[0].size[MIN]) races[0].size[MIN] = tempbug->size;
		if (tempbug->size > races[0].size[MAX]) races[0].size[MAX] = tempbug->size;
		
		races[tempbug->race].pop++;
		races[tempbug->race].age[AVERAGE] += tempbug->age;
		if (tempbug->age < races[tempbug->race].age[MIN]) races[tempbug->race].age[MIN] = tempbug->age;
		if (tempbug->age > races[tempbug->race].age[MAX]) races[tempbug->race].age[MAX] = tempbug->age;
		races[tempbug->race].food[AVERAGE] += tempbug->food;
		if (tempbug->food < races[tempbug->race].food[MIN]) races[tempbug->race].food[MIN] = tempbug->food;
		if (tempbug->food > races[tempbug->race].food[MAX]) races[tempbug->race].food[MAX] = tempbug->food;
		races[tempbug->race].gen[AVERAGE] += tempbug->generation;	
		if (tempbug->generation < races[tempbug->race].gen[MIN]) races[tempbug->race].gen[MIN] = tempbug->generation;
		if (tempbug->generation > races[tempbug->race].gen[MAX]) races[tempbug->race].gen[MAX] = tempbug->generation;
		races[tempbug->race].pred[AVERAGE] += tempbug->predlvl;
		if (tempbug->predlvl < races[tempbug->race].pred[MIN]) races[tempbug->race].pred[MIN] = tempbug->predlvl;
		if (tempbug->predlvl > races[tempbug->race].pred[MAX]) races[tempbug->race].pred[MAX] = tempbug->predlvl;
		races[tempbug->race].size[AVERAGE] += tempbug->size;
		if (tempbug->size < races[tempbug->race].size[MIN]) races[tempbug->race].size[MIN] = tempbug->size;
		if (tempbug->size > races[tempbug->race].size[MAX]) races[tempbug->race].size[MAX] = tempbug->size;
		
		tempbug = tempbug->next;
		races[0].pop++;
	}	
	
	for(temp = 0;temp < 256;temp++)
		if(races[temp].pop != 0)	
		{
			races[temp].age[AVERAGE] /= races[temp].pop;
			races[temp].food[AVERAGE] /= races[temp].pop;
			races[temp].gen[AVERAGE] /= races[temp].pop;
			races[temp].pred[AVERAGE] /= races[temp].pop;
			races[temp].size[AVERAGE] /= races[temp].pop;
		}
		     
	wprintw(stdscr,"Status -------------------------------------------------\n");
	wprintw(stdscr,"race pop	age		food		gen		pred	size\n");
	wprintw(stdscr,"all  %4.4i %4.4i/%4.4i/%4.4i %5.5i/%5.5i/%5.5i %3.3i/%3.3i/%3.3i %3.3i/%3.3i/%3.3i %i/%i/%i\n",races[0].pop,races[0].age[MIN],races[0].age[AVERAGE],races[0].age[MAX],races[0].food[MIN],races[0].food[AVERAGE],races[0].food[MAX],races[0].gen[MIN],races[0].gen[AVERAGE],races[0].gen[MAX],races[0].pred[MIN],races[0].pred[AVERAGE],races[0].pred[MAX],races[0].size[MIN],races[0].size[AVERAGE],races[0].size[MAX]);

	for(temp = 1;temp < 256;temp++)
		if(races[temp].pop != 0)
			wprintw(stdscr,"%c   %4.4i %4.4i/%4.4i/%4.4i %5.5i/%5.5i/%5.5i %3.3i/%3.3i/%3.3i %3.3i/%3.3i/%3.3i %i/%i/%i\n",temp,races[temp].pop,races[temp].age[MIN],races[temp].age[AVERAGE],races[temp].age[MAX],races[temp].food[MIN],races[temp].food[AVERAGE],races[temp].food[MAX],races[temp].gen[MIN],races[temp].gen[AVERAGE],races[temp].gen[MAX],races[temp].pred[MIN],races[temp].pred[AVERAGE],races[temp].pred[MAX],races[temp].size[MIN],races[temp].size[AVERAGE],races[temp].size[MAX]);
//			wprintw(stdscr,"%c	%i	%i/%i/%i	%i/%i/%i	%i/%i/%i	%i/%i/%i	%i/%i/%i\n",temp,races[temp].pop,races[temp].age[MIN],races[temp].age[AVERAGE],races[temp].age[MAX],races[temp].food[MIN],races[temp].food[AVERAGE],races[temp].food[MAX],races[temp].gen[MIN],races[temp].gen[AVERAGE],races[temp].gen[MAX],races[temp].pred[MIN],races[temp].pred[AVERAGE],races[temp].pred[MAX],races[temp].size[MIN],races[temp].size[AVERAGE],races[temp].size[MAX]);
//			wprintw(stdscr,"%c	%i	%i	%i	%i	%i	%i	\n",temp,races[temp].pop,races[temp].age,races[temp].food,races[temp].gen,races[temp].pred,races[temp].size);

	return;
}

