#include <curses.h>
#include <limits.h>
#include "bug3.h"

#define MIN 0
#define AVERAGE 1
#define MAX 2

struct counts
{ 
	int pop;
	int age[3];
	int food;
	int gen;
	int pred[3];
	int size[3];
};

void init_counts (struct counts *temp)
{
	temp->pop = 0;
	temp->age[AVERAGE] = 0;
	temp->age[MAX] = -1;
	temp->food = 0;
	temp->gen = 0;
	temp->pred[MIN] = INT_MAX;
	temp->pred[MAX] = INT_MIN;
	temp->size[MIN] = INT_MAX;
	temp->size[MAX] = INT_MIN;
	return;
}

void stat(void)
{
	struct bug *tempbug = bugs;
	struct counts races[256];
	int temp;
	
	clear();
	for(temp = 0;temp < 256;temp++)
		init_counts(&races[temp]);
	
	while(races[0].pop < population)
	{
		races[0].age[AVERAGE] += tempbug->age;
		races[0].food += tempbug->food;
		races[0].gen += tempbug->generation;
		races[0].pred[AVERAGE] += tempbug->predlvl;
		
		races[tempbug->race].pop++;

		races[tempbug->race].age[AVERAGE] += tempbug->age;
		if(tempbug->age > races[tempbug->race].age[MAX])
			races[tempbug->race].age[MAX] = tempbug->age;

		races[tempbug->race].food += tempbug->food;
		races[tempbug->race].gen += tempbug->generation;	

		if(tempbug->predlvl < races[tempbug->race].pred[MIN])
			races[tempbug->race].pred[MIN] = tempbug->predlvl;
		if(tempbug->predlvl > races[tempbug->race].pred[MAX])
			races[tempbug->race].pred[MAX] = tempbug->predlvl;

		if(tempbug->size < races[tempbug->race].size[MIN])
			races[tempbug->race].size[MIN] = tempbug->size;
		if(tempbug->size > races[tempbug->race].size[MAX])
			races[tempbug->race].size[MAX] = tempbug->size;
		
		tempbug = tempbug->next;
		races[0].pop++;
	}	
	
	for(temp = 0;temp < 256;temp++)
		if(races[temp].pop != 0)	
		{
			races[temp].age[AVERAGE] /= races[temp].pop;
			races[temp].food /= races[temp].pop;
			races[temp].gen /= races[temp].pop;
			races[temp].pred[AVERAGE] /= races[temp].pop;
		}
		     
	wprintw(stdscr,"Status ----------------------------------------------------------------------\n");
	wprintw(stdscr,"race	pop	age	amax	food	gen	pmin	pmax	smin	smax \n");
	wprintw(stdscr,"all	%i	%i		%i	%i				     \n",races[0].pop,races[0].age[AVERAGE],races[0].food,races[0].gen);

	for(temp = 1;temp < 256;temp++)
		if(races[temp].pop != 0)
			wprintw(stdscr,"%c	%i	%i	%i	%i	%i	%i	%i	%i	%i \n",temp,races[temp].pop,races[temp].age[AVERAGE],races[temp].age[MAX],races[temp].food,races[temp].gen,races[temp].pred[MIN],races[temp].pred[MAX],races[temp].size[MIN],races[temp].size[MAX]);

	return;
}

