// Bug2 header file
#ifndef BUG2_H
#define BUG2_H 

// enable debuger ...
// be shure to redirect stderr ...
#define DEBUG 0

// statistics ???
// again remeber to redirect stderr ...
#define STAT 0
void stat(void);

#define getrandom( min, max ) ((rand() % (int) (((max) + 1) - (min))) + (min))

// size of world
#define world_col (COLS * 5)
#define world_row (LINES * 5)

// used to set intial condition in start() ...
#define NUM_BUGS (world_col * world_row * .01)
#define NUM_FOOD (world_col * world_row * .1)
#define INIT_FOOD 30
#define LOW_RACE 'A'
#define HIGH_RACE 'Z'
#define NUM_BLOCKS (world_col * world_row * .05)

// search legnth ... how many genes in the DNA ...
#define S_LEN 25 

// how many food are used to mate ... 
#define MATE_COST 10

// things bugs might see ...
#define FOOD1 '.'
#define FOOD2 '*'
#define FOOD3 '@'
#define SPACE ' '
#define BLOCK '#'
#define PREDITOR '&'

// odds of the preditory mutation ... higher = less
#define PRED_ODDS 10
// how much a preditor gets for eating a bug ...
#define BUG_FOOD 20
// how much does it hurt the bug ???
#define BITE_SIZE 10

// FOOD_RATE min = 1 ... higher = slower ... 1 = always ...
#define FOOD_RATE 10

// a bug does what ???
#define WAIT 0
#define LEFT 1
#define RIGHT 2
#define FORWARD 3
// how bad a bug wants to run from a preditor ...
#define RUN 1

// this is to slow down the bugs ... higher is slower
int cpuwait;

// the bug structure
struct bug
{
	int xpos, ypos, vector;  
	int food;
	char food_type;
	char race;
	int age;
	int generation;
	int search[S_LEN];
	struct bug *prev;
	struct bug *next;
};

// current & "first"
struct bug *bugs, *first;

// status, highfood, high gen, oldest bugs ...
struct bug *sb, *hf, *hg, *old;

// population counter
int population;

// world_pad "the world"
WINDOW *world_pad;

// init ...
void init (void);

// set intial screen ...
void start(void);

// end program ...
void stop(void);

// the main function ...
// examine environment dicide what to do ...
int look(int);

// reproduce ...
void mate(void);
// with who ???
struct bug* findbug(int y, int x);

// poor bug ... rest in piece ...
void die(struct bug* temp);

// what a bug sees here ...
char peek(int fw, int lr);

// food growth ...
void growfood(void);
void placefood(void);

struct counts
{ 
	int pop, age, food, gen; 
};
void init_counts (struct counts *temp);

#endif /* BUG2_H */
