#include <term.h>
#include <curses.h>
#include "bug2.h"
#include "kb.h"

int main()
{
	int temp;
	int ch = 0;
	int search = 0;
	char *sbis = "xx \0";
	
	init();

	cpuwait = 1;
	first = bugs;
	sb = bugs;
	hf = bugs;
	hg = bugs;
	old = bugs;
	
	while(1)
	{
		if(bugs == first)
		{
			// be nice to the processor
			usleep(cpuwait);
			
			// next "gene"
			search = ++search % S_LEN;

			// user did what ???
			if(kb_hit())
				ch = read_kb();
						
			switch(ch)
			{
				case '1':
					sbis = "xx \0";
					sb = sb->next;
					ch = '\0';
					break;
				case '2':
					sbis = "hf \0";
					sb = hf;
					break;
				case '3':
					sbis = "hg \0";
					sb = hg;
					break;
				case '4':
					sbis = "old\0";
					sb = old;
					break;
				case 'x':
				case 'X':
					stop();
					break;
				case 'f':
				case 'F':
					if(cpuwait <= 1)
						cpuwait = 0;
					else
						cpuwait /= 2;
					ch = '\0';
					break;
				case 's':
				case 'S':
					if(cpuwait == 0)
						cpuwait = 1;
					else
						cpuwait *= 2;
					ch = '\0';
					break;				
				case 't':
				case 'T':
					cpuwait = 0;
					break;
				case 'p':
				case 'P':
				case 'n':
				case 'N':
					ch = '\0';
					while(((ch != 'p')&&(ch != 'P'))&&((ch != 'n')&&(ch != 'N')))
					{
						usleep(10000);
						refresh();
						
						if(kb_hit())
							ch = read_kb();
						else
						{
							attron(A_BOLD);
							ch = '\0';
						}
						mvprintw(sb->ypos,sb->xpos,"%c",sb->race);
						attroff(A_BOLD);

						switch(ch)
						{
							case '1':
								sbis = "xx \0";
								sb = sb->next;
								break;
							case '2':
								sbis = "hf \0";
								sb = hf;
								break;
							case '3':
								sbis = "hg \0";
								sb = hg;
								break;
							case '4':
								sbis = "old\0";
								sb = old;
								break;
							case 'x':
							case 'X':
								stop();
								break;
							case 's':
							case 'S':
							case 'f':
							case 'F':
								ch = 'p';
								break;
							case 't':
							case 'T':
								cpuwait = 0;
								ch = 'p';
								break;
							default:
								// any other key ...
								break;
						}
						// show status bar
						mvprintw(LINES-1, 0, "x 1 2 3 4 f s t p n  %s %c %i ",sbis,sb->race,sb->generation);
						for(temp = 0; temp < S_LEN; temp++)
							printw("%i",sb->search[temp]);
						printw(" %i %i   ",sb->food,sb->age);
					}
					if((ch != 'n')&&(ch != 'N'))
						ch = '\0';
					break;
				default:
					// user hit unused key
					break;
			}
				
			// show status bar
			mvprintw(LINES-1, 0, "x 1 2 3 4 f s t p n  %s %c %i ",sbis,sb->race,sb->generation);
			for(temp = 0; temp < S_LEN; temp++)
				printw("%i",sb->search[temp]);
			printw(" %i %i %i  ",sb->food,sb->age,cpuwait);
		}
		if(search == 0)
		{
			// get older
			bugs->age++;
			
			// did i starve to death ???
			if(--bugs->food <= 0)
			{
				if(DEBUG)
					fprintf(stderr,"strave\n");
				die(bugs);
			}
			
			if(bugs->food >= INIT_FOOD * 4)
			{
				mate();
				bugs->food /= 5;
			}
			// grow some food
			if(bugs == first)
			{
				growfood();
				if(STAT)
					stat();
			}
		}

		if (bugs->food > hf->food)
			hf = bugs;

		if (bugs->generation > hg->generation)
			hg = bugs;

		if (bugs->age > old->age)
			old = bugs;
			
		bugs = bugs->next;
		mvprintw(bugs->ypos,bugs->xpos," ");

		// what am i doing???
		switch(look(search))
		{
			case WAIT:
				// do nothing
				break;
			case LEFT:
				// turn left
				bugs->vector = (--bugs->vector + 4) % 4;        
				break;
			case RIGHT:
				// turn right
				bugs->vector = ++bugs->vector % 4;
				break;
			case FORWARD:
				// move ahead
				switch(bugs->vector)
				{
					case 0:
						// screen up
						bugs->ypos = (--bugs->ypos + LINES-1) % (LINES-1);
						break;
					case 1:
						// screen right
						bugs->xpos = (++bugs->xpos) % COLS;
						break;
					case 2:
						//screen down
						bugs->ypos = (++bugs->ypos) % (LINES-1);
						break;
					case 3: 
						// screen left
						bugs->xpos = (--bugs->xpos + COLS) % COLS;
						break;                                          
					default:
						fprintf(stderr, "default in main inner bugs->vector is bad\n");
						break;
				}
				break;
			default:
				fprintf(stderr, "default in main look returned a bad value\n");
				break;
		}
		if(bugs == sb)
			attron(A_BOLD);
		mvprintw(bugs->ypos,bugs->xpos,"%c",bugs->race);
		if(bugs == sb)
			attroff(A_BOLD);
		refresh();
	}
	// exit from while loop ... should never happen
	fprintf(stderr,"exited from main while loop this is bad ...\n");
	stop();
}
