#include <curses.h>
#include "bug2.h"

void die(struct bug *temp)
{
	population--;
	if(DEBUG)
		fprintf(stderr,"die\n");
	mvprintw(temp->ypos,temp->xpos,"%c",FOOD1);
	refresh();
	if(temp == bugs)
		bugs = bugs->prev;
	if(temp == first)
		first = first->prev;
	if(temp == sb)
		sb = sb->prev;
	if(temp == hg)
		hg = hg->prev;
	if(temp == old)
		old = old->prev;
	temp->prev->next = temp->next;
	temp->next->prev = temp->prev;
	if(bugs == bugs->next)
		stop();
	free(temp);
}

void mate(void)
{
	struct bug *temp;
	struct bug *mate;
	int loop2, val;
	char tempch[3];
	int distance = 1;
	
	population++;
	if(DEBUG)
		fprintf(stderr,"mate\n");
	// where is the mate???
	if(bugs->food < INIT_FOOD * 4)
		switch(bugs->vector)
		{
			case 0:
				// screen up
				mate = findbug((bugs->ypos - 1 + LINES-1) % (LINES-1),bugs->xpos);
				break;
			case 1:
				// screen right
				mate = findbug(bugs->ypos,(bugs->xpos + 1) % COLS);
				break;
			case 2:
				// screen down
				mate = findbug((bugs->ypos + 1) % (LINES-1),bugs->xpos);
				break;
			case 3: 
				// screen left
				mate = findbug(bugs->ypos,(bugs->xpos + COLS - 1) % COLS);
				break;                                          
			default:
				fprintf(stderr, "default in mate find bugs->vector is bad\n");
				break;
		}
	else
	{
		if(DEBUG)
			fprintf(stderr,"split\n");
		mate = bugs;
	}		
	temp = (struct bug *) malloc (sizeof(struct bug));
	
	while(tempch[0] != SPACE)
	{
		temp->ypos = -1;
		temp->xpos = -1;

		while((temp->ypos > LINES-2)||(temp->ypos < 0))
			temp->ypos = getrandom((bugs->ypos + LINES - 1 - distance) % (LINES - 1),(bugs->ypos + distance) % (LINES - 1));

		while((temp->xpos > COLS-1)||(temp->xpos < 0))
			temp->xpos = getrandom((bugs->xpos + COLS - distance) % COLS,(bugs->xpos + distance) % COLS);
	
		move(temp->ypos,temp->xpos);
		val = innstr(tempch,1);
		
		distance++;
	}

	temp->vector = getrandom(0,3);
	temp->food = INIT_FOOD / 2;
	if((getrandom(0,PRED_ODDS) == 0)||(bugs->race == PREDITOR))
	{
		temp->food_type = bugs->race;
		temp->race = PREDITOR;
	}
	else
	{
		temp->food_type = bugs->food_type;
		temp->race = bugs->race;
	}
	temp->generation = bugs->generation + 1;
	temp->age = 0;
	for(loop2 = 0; loop2 <= S_LEN; loop2++)
		switch(getrandom(0,8))
		{
			case 0:
			case 2:
			case 4:
			case 6: 
			case 8:
				// copy parent bugs
				temp->search[loop2] = bugs->search[loop2];      
				break;
			case 1:
			case 3:
			case 5:
				// copy parent mate
				temp->search[loop2] = mate->search[loop2];      
				break;
			case 7:
				// mutate
				temp->search[loop2] = getrandom(0,3);
				break;
			default:
				fprintf(stderr, "default in new genes ...\n");
				break;
		}
	temp->next = bugs->next;
	bugs->next->prev = temp;
	bugs->next = temp;
	temp->prev = bugs;
	bugs->food -= MATE_COST;
	return;
}
