#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#include <process.h>
#include "bug.h"

#define getrandom( min, max ) ((rand() % (int)(((max)+1) - (min))) + (min))

#define blue    (1 + 8)
#define green   (2 + 8)
#define cyan    (3 + 8)
#define red     (4 + 8)
#define magenta (5 + 8)
#define yellow  (6 + 8)
#define white   (7 + 8)

#define die_shift (2)
#define food_shift (1)

struct bug
{
	unsigned char column,row;  /* x,y */
	char color;
	unsigned char time_food;
	unsigned char count_food;
	struct bug *next;
} *bugs;

struct monster
{
	unsigned char column,row;  /* x,y */
	char color;
} preditor;

unsigned char videoMode, activePage, rows, columns;
char cell, attrib;

unsigned char split_food;
unsigned char die_time;
int num_colors;
int num_bugs;
int init_foods;

void init_screen(void);

int search_bug(struct bug *);
void move_bug(struct bug *);
void die(int);
void split(struct bug *);

void move_monster(void);
int search_monster(void);

int main(int argc, char *argv[])
{
	unsigned long delay = 100000L;

	if(argc != 2)
	{
		printf("useage bug num_bugs (num_bugs is between 2 and 6)\n");
		exit(2);
	}
	num_colors = atoi(argv[1]);
	num_bugs = num_colors * 4;
	init_foods = 25 * (6 - num_colors) + 300;
	die_time = (unsigned char)(init_foods / 3);
	split_food = (unsigned char)(num_colors / 2);

  srand( (unsigned)time( NULL ) );

	getScreenParameters(&videoMode, &activePage, &rows, &columns);
	setVideoMode(videoMode);

  init_screen();
	while(!kbhit())
	{
		suspendProgram(delay);
    move_bug(bugs);
		setCursorPosition(activePage, 1, 1);
	}
	return(0);
}

void init_screen(void)
{
	int loop;
	struct bug *ptemp, *x;

	for(loop = 0;loop < num_bugs;loop++)
	{
   	ptemp = (struct bug *)malloc(sizeof(struct bug));
    if(ptemp == NULL)
		{
			printf("\n\nmalloc error\n\n");
			exit(1);
		}
    switch(loop%num_colors)
		{
			case 0:
				ptemp->color = blue;
				break;
			case 1:
				ptemp->color = red;
				break;
			case 2:
				ptemp->color = green;
				break;
			case 3:
				ptemp->color = yellow;
				break;
			case 4:
				ptemp->color = magenta;
				break;
			case 5:
				ptemp->color = cyan;
				break;
    }
		cell = 'x';
		while(cell != ' ')
	  {
			ptemp->row = (unsigned char)getrandom(2,24);
	  	ptemp->column = (unsigned char)getrandom(1,79);
			setCursorPosition(activePage, ptemp->row, ptemp->column);
			readCell(activePage,&cell,&attrib);
		}
		setCursorPosition(activePage, ptemp->row, ptemp->column);
		ptemp->time_food = 0;
		ptemp->count_food = 0;
		writeCell(activePage, (unsigned char)'', ptemp->color, 1);

		if(loop == 0)
			bugs = ptemp;
		else
			x->next = ptemp;
		x = ptemp;
  }
	ptemp->next = bugs;
  ptemp = bugs;
	for(loop = 0;loop < init_foods;loop++)
	{
    cell = 'x';
		while(cell != ' ')
	  {
			setCursorPosition(activePage,
			  							 (unsigned char)getrandom(2,24),
		  								 (unsigned char)getrandom(1,79));
			readCell(activePage,&cell,&attrib);
		}
		writeCell(activePage, '@', ptemp->color, 1);
		ptemp = ptemp->next;
	}
  cell = 'x';
	preditor.color = white;
	while(cell != ' ')
	{
		setCursorPosition(activePage,
			  						 (unsigned char)getrandom(2,24),
		  							 (unsigned char)getrandom(1,79));
		readCell(activePage,&cell,&attrib);
	}
}

int search_bug(struct bug *pbug)
{
	int dir = 0;
  setCursorPosition(activePage,(unsigned char)((pbug->row - 1 == 1) ? 24 : (pbug->row - 1)), pbug->column);
	readCell(activePage,&cell,&attrib);
	if((cell == '@')&&(attrib != pbug->color))
		return(1);
	if(((cell == '@')&&(attrib == pbug->color))||(cell == '')||(cell == 'M'))
		dir += 8;

  setCursorPosition(activePage, pbug->row,(unsigned char)((pbug->column + 1 == 80) ? 1 : (pbug->column + 1)));
	readCell(activePage,&cell,&attrib);
	if((cell == '@')&&(attrib != pbug->color))
		return(2);
	if(((cell == '@')&&(attrib == pbug->color))||(cell == '')||(cell == 'M'))
		dir += 16;

  setCursorPosition(activePage,(unsigned char)((pbug->row + 1 == 25) ? 2 : (pbug->row + 1)), pbug->column);
	readCell(activePage,&cell,&attrib);
	if((cell == '@')&&(attrib != pbug->color))
		return(3);
	if(((cell == '@')&&(attrib == pbug->color))||(cell == '')||(cell == 'M'))
		dir += 32;

  setCursorPosition(activePage, pbug->row,(unsigned char)((pbug->column - 1 == 0) ? 79 : (pbug->column - 1)));
	readCell(activePage,&cell,&attrib);
	if((cell == '@')&&(attrib != pbug->color))
		return(4);
	if(((cell == '@')&&(attrib == pbug->color))||(cell == '')||(cell == 'M'))
		dir += 64;

	return(dir);
}

void move_bug(struct bug *pbugs)
{
	int loop;
	int move_dir;

	for(loop = 0;loop < num_bugs;loop++)
	{
    move_dir = search_bug(pbugs);
		setCursorPosition(activePage, pbugs->row, pbugs->column);
		writeCell(activePage, ' ', pbugs->color, 1);
    if(!move_dir)
    {
			move_dir = (unsigned char)getrandom(1,4);
			pbugs->time_food++;
			if(pbugs->time_food > die_time)
			{
				die(loop);
				move_dir = -1;
			}
		}
		else
		{
			if(move_dir < 5)
			{
				pbugs->count_food++;
				pbugs->time_food = 0;
				if(pbugs->count_food > split_food)
				{
					pbugs->count_food = 0;
					split(pbugs);
	      }
	      cell = 'x';
	      while(cell != ' ')
	      {
					setCursorPosition(activePage,
														(unsigned char)getrandom(2,24),
														(unsigned char)getrandom(1,79));
					readCell(activePage,&cell,&attrib);
				}
				writeCell(activePage, '@', pbugs->color, 1);
			}
    }
		switch(move_dir)
	  {
			case 8:
      	move_dir = (unsigned char)getrandom(2,4);
				break;
			case 16:
      	move_dir = (unsigned char)getrandom(2,4);
					if(move_dir == 2)
						move_dir = 1;
				break;
			case 24:
      	move_dir = (unsigned char)getrandom(3,4);
				break;
			case 32:
      	move_dir = (unsigned char)getrandom(1,3);
					if(move_dir == 3)
						move_dir = 4;
				break;
      case 40:
      	move_dir = (unsigned char)getrandom(1,2);
				move_dir *= 2;
				break;
      case 48:
      	move_dir = (unsigned char)getrandom(1,2);
					if(move_dir == 2)
						move_dir = 4;
				break;
			case 64:
      	move_dir = (unsigned char)getrandom(1,3);
				break;
      case 72:
      	move_dir = (unsigned char)getrandom(2,3);
				break;
			case 80:
      	move_dir = (unsigned char)getrandom(1,2);
					if(move_dir == 2)
						move_dir = 3;
				break;
      case 96:
      	move_dir = (unsigned char)getrandom(1,2);
				break;
			case 120:
				pbugs->row = (unsigned char)getrandom(2,24);
	  		pbugs->column = (unsigned char)getrandom(1,79);
				break;
		}
		switch(move_dir)
	  {
			case 112:
			case 1:                          /* up */
				pbugs->row -= 1;
				break;
      case 104:
			case 2:                          /* right */
			  pbugs->column += 1;
				break;
			case 88:
			case 3:                          /* down */
				pbugs->row += 1;
				break;
			case 56:
			case 4:                          /* left */
			  pbugs->column -= 1;
				break;
		}
		if(pbugs->row == 1)
			pbugs->row = 24;
		if(pbugs->column == 0)
			pbugs->column = 79;
		if(pbugs->row == 25)
			pbugs->row = 2;
		if(pbugs->column == 80)
			pbugs->column = 1;
		setCursorPosition(activePage, pbugs->row, pbugs->column);
		if(move_dir > 0)
			writeCell(activePage, (unsigned char)'', pbugs->color, 1);
		if(!(loop % 25))
			move_monster();
    pbugs = pbugs->next;
	}
}

void die(int what_bug)
{
	struct bug *pbug = bugs, *last;
	int loop;

	for(loop = 0;loop < (what_bug - 1);loop++)
		pbug = pbug->next;
	last = pbug;
	pbug = pbug->next;
  last->next = pbug->next;
	setCursorPosition(activePage, pbug->row, pbug->column);
	writeCell(activePage, ' ', pbug->color, 1);
	if(loop == 0)
		bugs = pbug->next;
	free(pbug);
	num_bugs--;
	split_food -= food_shift;
	if(split_food < 1)
		split_food = 1;
	die_time += die_shift;
}

void split(struct bug *what_bug)
{
	struct bug *ptemp;
  ptemp = (struct bug *)malloc(sizeof(struct bug));
  if(ptemp == NULL)
	{
		printf("\n\nmalloc error\n\n");
		exit(1);
	}
  ptemp->next = what_bug->next;
	what_bug->next = ptemp;
	ptemp->color = what_bug->color;
	cell = 'x';
	while(cell != ' ')
	{
		ptemp->row = (unsigned char)getrandom(2,24);
	  ptemp->column = (unsigned char)getrandom(1,79);
		setCursorPosition(activePage, ptemp->row, ptemp->column);
		readCell(activePage,&cell,&attrib);
	}
	setCursorPosition(activePage, ptemp->row, ptemp->column);
	ptemp->time_food = 0;
	ptemp->count_food = 0;
	writeCell(activePage, (unsigned char)'', ptemp->color, 1);
	num_bugs++;
	split_food += food_shift;
	die_time -= die_shift;
}

void move_monster(void)
{
	int move_dir;
	int loop;
	struct bug *pbug = bugs;

	move_dir = search_monster();
	setCursorPosition(activePage, preditor.row, preditor.column);
	writeCell(activePage, ' ', preditor.color, 1);
	if(!move_dir)
	  move_dir = (unsigned char)getrandom(1,4);
	switch(move_dir)
	{
		case 8:
	    move_dir = (unsigned char)getrandom(2,4);
			break;
		case 16:
	    move_dir = (unsigned char)getrandom(2,4);
				if(move_dir == 2)
					move_dir = 1;
			break;
		case 24:
	    move_dir = (unsigned char)getrandom(3,4);
			break;
		case 32:
	    move_dir = (unsigned char)getrandom(1,3);
				if(move_dir == 3)
					move_dir = 4;
			break;
	  case 40:
	    move_dir = (unsigned char)getrandom(1,2);
			move_dir *= 2;
			break;
	  case 48:
	    move_dir = (unsigned char)getrandom(1,2);
				if(move_dir == 2)
					move_dir = 4;
			break;
		case 64:
	    move_dir = (unsigned char)getrandom(1,3);
			break;
	  case 72:
	    move_dir = (unsigned char)getrandom(2,3);
			break;
		case 80:
	    move_dir = (unsigned char)getrandom(1,2);
				if(move_dir == 2)
					move_dir = 3;
			break;
	  case 96:
	    move_dir = (unsigned char)getrandom(1,2);
			break;
		case 120:
			preditor.row = (unsigned char)getrandom(2,24);
		  preditor.column = (unsigned char)getrandom(1,79);
			break;
	}
	switch(move_dir)
	{
		case 112:
		case 1:                          /* up */
			preditor.row -= 1;
			break;
	  case 104:
		case 2:                          /* right */
			preditor.column += 1;
			break;
		case 88:
		case 3:                          /* down */
			preditor.row += 1;
			break;
		case 56:
		case 4:                          /* left */
			preditor.column -= 1;
			break;
	}
	if(preditor.row == 1)
		preditor.row = 24;
	if(preditor.column == 0)
		preditor.column = 79;
	if(preditor.row == 25)
		preditor.row = 2;
	if(preditor.column == 80)
		preditor.column = 1;
	setCursorPosition(activePage, preditor.row, preditor.column);
	writeCell(activePage, 'M', preditor.color, 1);
	for(loop = 0;loop < num_bugs;loop++)
	{
		if((preditor.row == pbug->row)&&(preditor.column == pbug->column))
			die(loop);
		pbug = pbug->next;
	}
}

int search_monster(void)
{
	int dir = 0;
  setCursorPosition(activePage,(unsigned char)((preditor.row - 1 == 1) ? 24 : (preditor.row - 1)), preditor.column);
	readCell(activePage,&cell,&attrib);
	if(cell == '')
		return(1);
	if(cell != ' ')
		dir += 8;

  setCursorPosition(activePage, preditor.row,(unsigned char)((preditor.column + 1 == 80) ? 1 : (preditor.column + 1)));
	readCell(activePage,&cell,&attrib);
	if(cell == '')
		return(2);
	if(cell != ' ')
		dir += 16;

  setCursorPosition(activePage,(unsigned char)((preditor.row + 1 == 25) ? 2 : (preditor.row + 1)), preditor.column);
	readCell(activePage,&cell,&attrib);
	if(cell == '')
		return(3);
	if(cell != ' ')
		dir += 32;

  setCursorPosition(activePage, preditor.row,(unsigned char)((preditor.column - 1 == 0) ? 79 : (preditor.column - 1)));
	readCell(activePage,&cell,&attrib);
	if(cell == '')
		return(4);
	if(cell != ' ')
		dir += 64;

	return(dir);
}
