#include <bios.h>
#include "vid.h"

/* Sets a video mode */
void setVideoMode( unsigned char newMode )
{
	union REGS regs;

	regs.h.ah = 0;                   /* AH = 0 - set video mode */
	regs.h.al = newMode;             /* AL = desired video mode */
	int86( 0x10, &regs, &regs );     /* Call BIOS */
}                                /* Returns nothing */

/* Sets cursor position */
void setCursorPosition( unsigned char videoPage,
								unsigned char row,
								unsigned char column )
{
	union REGS regs;

	regs.h.ah = 2;                /* AH = 2 - set cursor position */
	regs.h.bh = videoPage;        /* BH = video page */
	regs.h.dh = row;              /* DH = row */
	regs.h.dl = column;           /* DL = column */
	int86( 0x10, &regs, &regs );  /* Call BIOS */
}                             /* Returns nothing */

/* Writes character and attribute to specified video page */
void writeCell( unsigned char videoPage,
					 unsigned char character,
					 unsigned char attribute,
					 unsigned int times )
{
	union REGS regs;

	regs.h.ah = 9;                /* AH = 9 - write char and attribute */
	regs.h.al = character;        /* AL = character */
	regs.h.bh = videoPage;        /* BH = video page */
	regs.h.bl = attribute;        /* BL = attribute */
	regs.x.cx = times;            /* CX = number of times to write character */
	int86( 0x10, &regs, &regs );  /* Call BIOS */
}                             /* Returns nothing */

/* Returns character and attribute at current cursor position */
void readCell( unsigned char videoPage,
					unsigned char *pChar,
					unsigned char *pAttribute )
{
	union REGS regs;

	regs.h.ah = 8;                /* AH = 8 - read character and attribute */
	regs.h.bh = videoPage;        /* BH = video page */
	int86( 0x10, &regs, &regs );  /* Call BIOS */

	*pChar = regs.h.al;           /* AL = character */
	*pAttribute = regs.h.ah;      /* AH = attribute */
}

/* Determine Numbers of Screen Rows and Columns */
void getScreenParameters( unsigned char *videoMode,
								  unsigned char *activePage,
								  unsigned char *textRows,
								  unsigned char *textColumns )
{
  union REGS regs;

	regs.h.ah = 0x0f;               /* AH = 0x0F - get screen parameters */
	int86( 0x10, &regs, &regs );    /* Call BIOS */

	*videoMode = regs.h.al;         /* AL = current video mode */
	*activePage = regs.h.bh;        /* BH = active video page */
	*textColumns = regs.h.ah;       /* AH = number of screen columns */
	*textRows = (unsigned char)(*(unsigned int _far *)0x00400084 + 1);      /* Number of screen rows from BDA */
}

/* Suspends program execution for n microseconds */
unsigned int suspendProgram( unsigned long timeValue )
{
	union REGS regs;

	regs.h.ah = 0x86;                /* AH = 86h - suspend program */
	regs.x.cx = (unsigned int)(timeValue >> 16);   /* CX = high 16 bits of timeout */
	regs.x.dx = (unsigned int)timeValue;           /* DX = low 16 bits of timeout */
	int86( 0x15, &regs, &regs );     /* Call BIOS */

	return( regs.x.cflag );          /* Return Carry flag as indicator */
}
