package jbugs.utils;

import java.util.Random;
import java.lang.Math;

public class BugMath {
	/**
	 * Random number generator used for the entire application.
	 * Seeded with the current system time.
	 */
	final private static Random random = new Random(System.currentTimeMillis());
	
	/**
	 * Natural log of 10. Used to calculate log base 10 of any number
	 * log b a = (log c a)/(log c b)
	 */
	final private static double NLOG10 = Math.log(10);
	
	/**
	 * Returns an integer random number between min & max
	 * @param	min	Lower limit for the random number
	 * @param	max	Upper limit for the random number
	 */
	public static int getRandom(double min, double max) {
		int next_rand = Math.abs(random.nextInt());
		return (int)((next_rand % (((max) + 1) - (min))) + (min));
	}
	
	/**
	 * Performs a log base 10 on 'number'
	 * @param	number	Number we want the log base 10 of
	 */
	public static double log10(double number) {
		return (Math.log(number)/NLOG10);
	}
}
