package jbugs.ui;

import javax.swing.JPanel;
import jbugs.devices.VirtualScreen;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Font;
import java.awt.Color;

public class WorldPanel extends JPanel {
	
	private VirtualScreen screen;
	
	/**
	 * Default constructor for the world panel
	 */
	public WorldPanel() {
		super();
		this.setPreferredSize(new Dimension(1000,510));
		screen = null;	// By default, this should be null.
	}
	
	/**
	 * Sets the virtual screen to draw from
	 * @param	new_screen	VirtualScreen to draw from
	 */
	public void setVirtualScreen(VirtualScreen new_screen) {
		screen = new_screen;
	}
	
	/*public void update(Graphics g) {
		Graphics offgc;
		Image offscreen = null;
		Dimension d = this.getSize();

		// create the offscreen buffer and associated Graphics
		offscreen = createImage(d.width, d.height);
		offgc = offscreen.getGraphics();
		// clear the exposed area
		offgc.setColor(this.getBackground());
		offgc.fillRect(0, 0, d.width, d.height);
		offgc.setColor(getForeground());
		// do normal redraw
		if (screen == null) {
			System.out.println("No virtual screen to display.");
			return;
		}
		Font font = new Font("Monospaced",Font.BOLD,20);
		int yoffset = 20;
		
		offgc.setFont(font);
		for (int y=0; y < screen.getHeight(); y++, yoffset+=20) {
			offgc.drawString(screen.getRowString(y), 10, yoffset);
		}
		this.paint(offgc);
		// transfer offscreen to window
		g.drawImage(offscreen, 0, 0, this);

	}
	
	public void paint(Graphics g) {
		//super.paint(g);
		update(g);
	}*/
	public void paint(Graphics g) {
		if (screen == null) {
			System.out.println("No virtual screen to display.");
			return;
		}
		Font font = new Font("Monospaced",Font.BOLD,20);
		int yoffset = 20;
		
		g.setColor(Color.gray);
		g.fillRect(0,0,this.getWidth(), this.getHeight());
		g.setColor(Color.black);
		
		//screen.pad();
		g.setFont(font);
		for (int y=0; y < screen.getHeight(); y++, yoffset+=20) {
			g.drawString(screen.getRowString(y), 10, yoffset);
		}
	}
}
