package jbugs.ui;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;


import jbugs.ui.ControlPanel;
import jbugs.ui.WorldPanel;
import jbugs.devices.VirtualScreen;

public class UserInterface extends JPanel {
	
	// ------ Data members ------
	
	/**
	 * Control panel to be added to the user interface
	 */
	private ControlPanel control_panel;
	
	/**
	 * World panel to be added to the user interface
	 */
	private WorldPanel world_panel;
	
	/**
	 * Scroll panel used to move around the 'world' panel
	 */
	private JScrollPane scroll_window;
	
	/**
	 * GridBagLayout to use for the layout of all components
	 */
	private GridBagLayout myGridBag;
	
	// ------ Constructor ------
	/**
	 * Default empty constructor
	 */
	public UserInterface() {
		super();
		myGridBag = new GridBagLayout();
		this.setLayout(myGridBag);
		control_panel = new ControlPanel();
		world_panel = new WorldPanel();
		scroll_window = new JScrollPane(world_panel);
		buildUserInterface();
	}
	
	/**
	 * Places constraints on each of the panels & attaches them to the root 'panel'
	 */
	private void buildUserInterface() {
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridwidth = gbc.gridheight = 1;
		gbc.fill = gbc.BOTH;
		gbc.weightx = 100;	// Take up 100% of the width
		/* Now, place each component on the panel */
		gbc.gridx = gbc.gridy = 0;
		gbc.weighty = 80;	// Take up 80% in the y direction
		myGridBag.setConstraints(scroll_window, gbc);
		this.add(scroll_window);
		gbc.gridy = 1;
		gbc.weighty = 20;	// Take up the remaining 20% of the panel in the y direction
		myGridBag.setConstraints(control_panel, gbc);
		this.add(control_panel);
	}
	
	public void setVirtualScreens(VirtualScreen new_screen) {
		world_panel.setVirtualScreen(new_screen);
	}
	
	public void rePaint() {
		world_panel.repaint();
	}	
}
