package jbugs.ui;

import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import jbugs.ui.UserInterface;
import jbugs.devices.VirtualScreen;

public class BugFrame extends JFrame {
	
	private UserInterface user_interface;
	private JMenuBar menu_bar;
	
	public BugFrame() {
		super("JBugs - Testing");
		user_interface = new UserInterface();
		menu_bar = new JMenuBar();
		addMenus();
		this.setJMenuBar(menu_bar);
		this.setContentPane(user_interface);
		this.addWindowListener(new WindowAdapter() {
      		public void windowClosing(WindowEvent e) {
        		System.out.println("Closing bugs window & exiting");
        		System.exit(0);
      		}
    	});
    	this.setSize(900,600);
	}
	
	public void setVirtualScreens(VirtualScreen new_screen) {
		user_interface.setVirtualScreens(new_screen);
	}
	
	public void rePaint() { user_interface.rePaint(); }
	
	private void addMenus() {
		JMenu file = new JMenu("File");
		JMenu help = new JMenu("Help");
		menu_bar.add(file);
		menu_bar.add(help);
	}	
}
