package jbugs.resources;

import jbugs.devices.VirtualScreen;
import jbugs.land.Terrain;
import jbugs.utils.BugMath;

public class Food {
	
	// ------ Constants ------
	
	/**
	 * Character to represent level 1 food
	 */
	final public static char FOOD1 = '.';
	
	/**
	 * Character to represent level 2 food
	 */
	final public static char FOOD2 = '*';
	
	/**
	 * Character to represent level 3 food
	 */
	final public static char FOOD3 = '@';
	
	/**
	 * Character to represent level 4 food
	 */
	final public static char FOOD4 = '!';
	
	/**
	 * Food rate
	 */
	final public static int  FOOD_RATE = 10;
	
	/**
	 * Food val
	 */
	final public static int  FOOD_VAL = 50;
	
	/**
	 * Food grow
	 */
	final public static int  FOOD_GROW = 25;
	
	// ------ Data members ------
	/**
	 * Screen to draw food to
	 */
	private VirtualScreen screen;
	private double num_food;
	
	// ------ Constructors ------
	
	/**
	 * Created a Food object with default parameters
	 */
	public Food() {
		screen = null;	// Set to null to be sure
		num_food = 0.0;
	}
	
	// ------ Methods ------
	/**
	 * Sets the virtual screen to draw from
	 * @param	new_screen	VirtualScreen to draw from
	 */
	public void setVirtualScreen(VirtualScreen new_screen) {
		screen = new_screen;
		num_food = screen.getWidth() * screen.getHeight() * .1;
	}
	
	public double getNumFood() {
		return num_food;
	}
	
	/**
	 * Causes food to grow
	 */
	public void growFood() {
		int xf, yf, ans;
		final int world_col = screen.getWidth(), world_row = screen.getHeight();
		
		for (xf = 0; xf < world_col; xf++) {
			for (yf = 0; yf < world_row; yf++) {
				if (screen.getCharAt(yf,xf) == Food.FOOD2)
					screen.setCharAt(yf,xf,Food.FOOD4);
				if (screen.getCharAt(yf,xf) == Food.FOOD1)
					screen.setCharAt(yf,xf,Food.FOOD2);
			} // for yf 
		} // for xf
		
		for (xf = 0; xf < world_col; xf++) {
			for (yf = 0; yf < world_row; yf++) {
				ans = (yf - 1 + world_row) % world_row;
				switch (screen.getCharAt(ans, xf)) {
					case Terrain.SPC : {
						screen.setCharAt(ans,xf,Food.FOOD1);
						break;
					}
				default: {
					// Do nothing
					}
				}
				
				ans = (xf + 1) % world_col;
				switch (screen.getCharAt(yf,ans)) {
					case Terrain.SPC : {
						screen.setCharAt(yf,ans,Food.FOOD1);
						break;
					}
					default: {
						// Do nothing
						break;
					}
				}
				
				ans = (yf +1) % world_row;
				switch (screen.getCharAt(ans,xf)) {
					case Terrain.SPC: {
						screen.setCharAt(ans,xf,Food.FOOD1);
						break;
					}
					default : {
						// Do Nothing
					}
				}
				
				ans = (xf - 1 + world_col) % world_col;
				switch (screen.getCharAt(yf,ans)) {
					case Terrain.SPC : {
						screen.setCharAt(yf,ans,Food.FOOD1);
						break;
					}
					default : {
						// Do nothing
						break;
					}
				}
				
			} // for yf
		} // for xf
		
		for (xf = 0; xf < world_col; xf++) {
			for (yf = 0; yf < world_row; yf++) {
				switch (screen.getCharAt(yf,xf)) {
					case Food.FOOD4 : {
						screen.setCharAt(yf,xf,Food.FOOD3);
					}
					default : {
						// Do nothing
						break;
					}
				}
			} // for yf
		} // for xf
	}
	
	/**
	 * Places food onto the world
	 */
	public void placeFood() {
		int x,y;
		
		if (BugMath.getRandom(0, Food.FOOD_RATE) > 1)
			return;
		y = BugMath.getRandom(0, screen.getHeight()-1);
		x = BugMath.getRandom(0, screen.getWidth()-1);
		
		switch (screen.getCharAt(y,x)) {
			case Terrain.SPC : {
				screen.setCharAt(y,x,Food.FOOD1);
				break;
			}
			default : {
				// Do nothing
				break;
			}
		}
	}	
}
