package jbugs.lifeforms;

import jbugs.resources.Food;
import jbugs.devices.VirtualScreen;
import jbugs.land.Terrain;
import jbugs.utils.BugMath;

import java.util.Vector;
import java.awt.Dimension;


public class Bug {
	// ------ Constants ------
	final public static int BUG_FOOD = 6;
	final public static double RF = (3/4);
	final public static int ID = 5;
	final public static char L_RACE = 'A';
	final public static char H_RACE = 'Z';
	final public static int L_SIZE = 2;
	final public static int H_SIZE = 100;
	final public static int D_SIZE = 10;
	final public static int L_SKILL = 0;
	final public static int H_SKILL = 100;
	final public static int D_SKILL = 10;
	final public static int L_FOV = 1;
	final public static int H_FOV = 10;
	final public static int WAIT = 0;
	final public static int LEFT = 1;
	final public static int RIGHT = 2;
	final public static int FORWARD = 3;
	final public static int THINGS_SIZE = 256;
	final public static int SCREEN_UP = 0;
	final public static int SCREEN_RIGHT = 1;
	final public static int SCREEN_DOWN = 2;
	final public static int SCREEN_LEFT = 3;
	private int mate_cost;
	private int mate_lvl;
	private int split_lvl;
	private int uff;
	private int wait_f;
	private int turn_f;
	private int move_f;
	// ------ Data members ------
	/**
	 * X location in the virtual screen
	 */
	private int xpos;
	
	/**
	 * Y position in the virtual screen
	 */
	private int ypos;
	
	/**
	 * Direction the bug is facing on the world
	 */
	private int vector;
	
	/**
	 * Food
	 */
	private int food;
	
	/**
	 * Race of the bug
	 */
	private char race;
	
	/**
	 * Age of the bug
	 */
	private int age;
	
	/**
	 * Size
	 */
	private int size;
	
	/**
	 * Attack
	 */
	private int attack;
	
	/**
	 * Defense
	 */
	private int defend;
	
	/**
	 * Generation
	 */
	private int gen;
	/**
	 * Fov
	 */
	private int fov;
	
	/**
	 * Things
	 */
	private int things[];
	
	// ------ Static member ------
	
	/**
	 * Vector of all bugs. All bugs are added to this list so they can find other bugs
	 */
	private static Vector bugs = new Vector();
	
	// ------ Constructors ------
	
	/**
	 * Default empty constructor
	 */
	public Bug() {
		things = new int[THINGS_SIZE];
	}
	
	public void setXpos(int new_x) {
		xpos = new_x;
	}
	
	public void setYpos(int new_y) {
		ypos = new_y;
	}
	
	public void setVector(int new_v) {
		vector = new_v;
	}
	
	public void setFood(int new_food) {
		food = new_food;
	}
	
	public void setRace(char new_race) {
		race = new_race;
	}
	
	public void setAge(int new_age) {
		age = new_age;
	}
	
	public void setSize(int new_size) {
		size = new_size;
		/* Set up other life parameters based on its size */
		mate_cost = Food.FOOD_VAL * size;
		mate_lvl = (4 * mate_cost);
		split_lvl = (mate_lvl * 2);
		uff = (int)(1 + Math.sqrt(size));
		wait_f = uff;
		turn_f = (int)(1.4 * uff);
		move_f = (int)(2 * uff);
	}
	
	public void setAttack(int new_attack) {
		attack = new_attack;
	}
	
	public void	setDefend(int new_defend) {
		defend = new_defend;
	}
	
	public void setGeneration(int new_gen) {
		gen = new_gen;
	}
	
	public void setFov(int new_fov) {
		fov = new_fov;
	}
	
	public void setThingAt(int index, int data) {
		things[index] = data;
	}
	
	public int getXpos() { return xpos; }
	public int getYpos() { return ypos; }
	public int getVector() { return vector; }
	public int getFood() { return food; }
	public char getRace() { return race; }
	public int getAge() { return age; }
	public int getSize() { return size; }
	public int getAttack() { return attack; }
	public int getDefend() { return defend; }
	public int getGeneration() { return gen; }
	public int getFov() { return fov; }
	public int getThingAt(int index) { return things[index]; }
	public int getMateCost() { return mate_cost; }
	public int getMateLevel() { return mate_lvl; }
	public int getSplitLevel() { return split_lvl; }
	public int getWaitF() { return wait_f; }
	public int getTurnF() { return turn_f; }
	public int getMoveF() { return move_f; }
	
	public static boolean isBug(char data) {
		return ((data >= Bug.L_RACE) && (data <= Bug.H_RACE) ? true : false);
	}
	
	public void addToList() {
		Bug.bugs.add(this);
		System.out.println("There are " + Bug.bugs.size());
	}
	
	public Bug getNextBug() {
		int index;
		
		index = Bug.bugs.indexOf(this);
		if (index == Bug.bugs.size()-1) {
			index = 0;
		} else
			index++;
			
		return (Bug)(Bug.bugs.elementAt(index));
	}
	
	public int look(VirtualScreen screen) {
		Bug bitten;
		char temp;
		float leftw = 0, rightw = 0, forwardw = 0;
		final int world_row = screen.getHeight(), world_col = screen.getWidth();
		
		/* Look for mate and/or food */
		temp = peek(screen);
		if ((temp == this.getRace()) && (this.getFood() > this.getMateLevel())) {
			mate(screen);
			return Bug.WAIT;
		}
		
		if (this.getThingAt(temp) > 0) {
			if (temp == Food.FOOD3) {
				//placefood
				this.setFood( this.getFood() + Food.FOOD_VAL );
				return Bug.FORWARD;
			}
			if ((Bug.isBug(temp)) && (temp != this.getRace())) {
				/* Who are we biting */
				bitten = Bug.findBug((this.getYpos() + look_c(this.getVector()) + world_row) % world_row,
									(this.getXpos() + look_c(this.getVector()+1) + world_col) % world_col);
				if (this.getThingAt(Food.FOOD3) < 0)
					bitten.setThingAt(this.getRace(), bitten.getThingAt(this.getRace()) - this.getSize());
				
				bitten.setFood( bitten.getFood() - this.getSize() + this.getAttack() - bitten.getDefend() );
				if (bitten.getFood() < 0 ) {
					this.setFood( this.getFood() + bitten.getSize() * Bug.BUG_FOOD * Food.FOOD_VAL );
					this.setThingAt(bitten.getRace(), this.getThingAt(bitten.getRace()) + bitten.getSize() );
					this.setThingAt(Food.FOOD3,this.getThingAt(Food.FOOD3)-1);
					if ((this.getAttack() < bitten.getDefend()) && (this.getAttack() < Bug.H_SKILL)) {
						this.setAttack(this.getAttack()+1);
						if ((this.getAttack() + this.getDefend()) > this.getSize()) {
							this.setDefend(this.getDefend()-1);
							if (this.getDefend() < Bug.L_SKILL)
								this.setDefend(Bug.L_SKILL);
						}
					}
					bitten.die(screen);
				} else {
					if ((bitten.getDefend() < this.getAttack()) && (bitten.getDefend() < Bug.H_SKILL)) {
						bitten.setDefend(bitten.getDefend()+1);
						if ((bitten.getDefend() + bitten.getAttack()) > bitten.getSize()) {
							bitten.setAttack(bitten.getAttack()-1);
							if (bitten.getAttack() < Bug.L_SKILL)
								bitten.setAttack(Bug.L_SKILL);
						}
					}
				}
				return Bug.WAIT;
			}
		}
		/* Gather data */
		
		forwardw = look_b(screen, 1, this.getVector(), look_c(this.getVector()+0), look_c(this.getVector() + 1));
		rightw = look_b(screen, 2, this.getVector()+1, look_c(this.getVector()+1), look_c(this.getVector() + 2));
		leftw = look_b(screen, 2, this.getVector() + 3, look_c(this.getVector()+3), look_c(this.getVector()+0));
		forwardw -= look_b(screen, 3, this.getVector()+2, look_c(this.getVector()+2), look_c(this.getVector()+3));
		
		/* Forward > left & right */
		if ((leftw > rightw) && (leftw > forwardw))
			return (((forwardw > 0) && (isPass(temp))) ? Bug.FORWARD : BugMath.getRandom(Bug.LEFT,Bug.RIGHT));
		/* Left > forward & right */
		if ((leftw > rightw) && (leftw > forwardw))
			return ((leftw > 0) ? Bug.LEFT : ((isPass(temp)) ? BugMath.getRandom(Bug.LEFT,Bug.RIGHT) : Bug.RIGHT));
		/* Right > left & forward */
		if ((rightw > leftw) && (rightw > forwardw))
			return ((rightw > 0) ? Bug.RIGHT : ((isPass(temp)) ? (BugMath.getRandom(0,1) ==1 ? Bug.LEFT: Bug.FORWARD) : Bug.LEFT));
		/* left & right > forward */
		if ((leftw == rightw) && (rightw > forwardw))
			return BugMath.getRandom(Bug.LEFT,Bug.RIGHT);
		/* forward & right > left */
		if ((forwardw == rightw) && (rightw > leftw))
			return ((isPass(temp)) ? BugMath.getRandom(Bug.RIGHT,Bug.FORWARD) : Bug.RIGHT);
		/* forward & left > right */
		if ((forwardw == leftw) && (leftw > rightw))
			return ((isPass(temp)) ? (BugMath.getRandom(0,1) == 1 ? Bug.LEFT : Bug.FORWARD) : Bug.LEFT);
		/* all equal .. bug is stumped... this is clever :) */
		return BugMath.getRandom(Bug.WAIT, (Bug.RIGHT + (isPass(temp) ? 1 : 0)));
	}
	
	public void die(VirtualScreen screen) {
		Bug.bugs.removeElement(this);
		screen.setCharAt(ypos,xpos,Food.FOOD1);
	}
	
	public void mate(VirtualScreen screen) {
		Bug temp = null;
		Bug mate = null;
		int loop2;
		int distance = 1;
		int tmin,tmax;
		final int world_row = screen.getHeight(), world_col = screen.getWidth();
			
		
		
		/* Where is the mate? */
		if (this.getFood() < this.getSplitLevel()) {
			switch (this.getVector()) {
				case Bug.SCREEN_UP : {
					mate = Bug.findBug((this.getYpos() - 1 + world_row) % world_row, this.getXpos());
					break;
				}
				case Bug.SCREEN_RIGHT : {
					mate = Bug.findBug(this.getYpos(), (this.getXpos() + 1) % world_col);
					break;
				}
				case Bug.SCREEN_DOWN : {
					mate = Bug.findBug((this.getYpos() + 1) % world_row, this.getXpos());
					break;
				}
				case Bug.SCREEN_LEFT : {
					mate = Bug.findBug(this.getYpos(), (this.getXpos() - 1 + world_col) % world_col);
					break;
				}
				default : {
					System.out.println("Default in mate find bugs->vector is bad");
					break;
				}
			} // Switch
		} else {
			mate = this;
		}
		
		temp = new Bug();
		
		do {
			temp.setYpos(-1);
			temp.setXpos(-1);
			tmin = (this.getYpos() + world_row - BugMath.getRandom(1,distance)) % world_row;
			tmax = (this.getYpos() + BugMath.getRandom(1,distance)) % world_row;
			while ((temp.getYpos() < 0) || (temp.getYpos() > world_row)) {
				temp.setYpos( (tmin < tmax) ? BugMath.getRandom(tmin,tmax) : BugMath.getRandom(tmax,tmin) );
			}
			tmin = (this.getXpos() + world_col - BugMath.getRandom(1,distance)) % world_col;
			tmax = (this.getXpos() + BugMath.getRandom(1,distance)) % world_col;
			while ((temp.getXpos() < 0) || (temp.getXpos() > world_col)) {
				temp.setXpos((tmin < tmax) ? BugMath.getRandom(tmin,tmax) : BugMath.getRandom(tmax,tmin));
			}
			if (++distance > 20) {
				this.setFood( ((this.getFood() * 2) / 3) - this.getMateCost() );
				/* We failed, kill the new guy */
				temp = null;
				System.gc();
				return;				
			}
			
		} while (screen.getCharAt(this.getYpos(),this.getXpos()) != Terrain.SPC);
		
		temp.setRace( this.getRace() );
		temp.setGeneration( this.getGeneration() + 1 );
		temp.setVector( BugMath.getRandom(Bug.SCREEN_UP,Bug.SCREEN_LEFT) );
		temp.setAge(0);
		
		temp.setSize( this.getSize() + BugMath.getRandom(-Bug.D_SIZE,Bug.D_SIZE) );
		if (temp.getSize() < Bug.L_SIZE)
			temp.setSize(Bug.L_SIZE);
		if (temp.getSize() > Bug.H_SIZE)
			temp.setSize(Bug.H_SIZE);
			
		temp.setAttack( this.getAttack() + BugMath.getRandom(-Bug.D_SKILL,Bug.D_SKILL) );
		if (temp.getAttack() < Bug.L_SKILL)
			temp.setAttack(Bug.L_SKILL);
		if (temp.getAttack() > Bug.H_SKILL)
			temp.setAttack( Bug.H_SKILL );
		
		temp.setDefend( this.getDefend() + BugMath.getRandom(-Bug.D_SKILL,Bug.D_SKILL) );
		if (temp.getDefend() < Bug.L_SKILL)
			temp.setDefend( Bug.L_SKILL );
		if (temp.getDefend() > Bug.H_SKILL)
			temp.setDefend(Bug.H_SKILL);
		
		while ((temp.getAttack() + temp.getDefend()) > temp.getSize()) {
			temp.setAttack(temp.getAttack()-1);
			if (temp.getAttack() < Bug.L_SKILL)
				temp.setAttack(Bug.L_SKILL);
			temp.setDefend(temp.getDefend()-1);
			if (temp.getDefend() < Bug.L_SKILL)
				temp.setDefend( Bug.L_SKILL );
		}
		
		temp.setFov((int)(Math.sqrt(temp.getSize())));
		if (temp.getFov() > Bug.H_FOV)
			temp.setFov(Bug.H_FOV);
		
		temp.setFood( this.getFood() / 3 );
		this.setFood( ((this.getFood() * 2) /3) - this.getMateCost() );
		
		for (loop2 = 0; loop2 < Bug.THINGS_SIZE; loop2++) {
			temp.setThingAt(loop2,(int)(this.getThingAt(loop2) * Bug.RF));
			if ((Bug.isBug((char)loop2)) && (temp.getThingAt(loop2) == 0)) {
				temp.setThingAt(loop2,BugMath.getRandom(-Bug.ID,Bug.ID));
			}
		}
		
		temp.setThingAt(Food.FOOD3, temp.getThingAt(Food.FOOD3) + BugMath.getRandom(-Bug.ID,Bug.ID));
		if (temp.getThingAt(Food.FOOD3) > Food.FOOD_VAL)
			temp.setThingAt(Food.FOOD3,Food.FOOD_VAL);
		int index = Bug.bugs.indexOf(this);
		Bug.bugs.insertElementAt(temp,index);
	}
	
	public static Bug findBug(int y, int x) {
		Bug temp1 = (Bug)(Bug.bugs.firstElement());
		
		while ((temp1.getXpos() == x) && (temp1.getYpos() == y)) {
			temp1 = temp1.getNextBug();
			if (temp1 == (Bug)(Bug.bugs.firstElement())) {
				System.out.println("This bug is FUCKED");
				System.out.println("Bug x = " + temp1.getXpos());
				System.out.println("Bug y = " + temp1.getYpos());
				System.out.println("Bug v = " + temp1.getVector());
				System.out.println("Look x = " + x);
				System.out.println("Look y = " + y);
				System.exit(-1);
			}
		}
		
		return temp1;
	}
	
	private char peek(VirtualScreen screen) {
		final int world_col = screen.getWidth(), world_row = screen.getHeight();
		
		return (screen.getCharAt( (this.getYpos() + world_row + look_c(this.getVector()+0)) % world_row,
								  (this.getXpos() + world_col + look_c(this.getVector()+1)) % world_col));
	}
	
	private int look_c(int vec) {
		switch (vec % 4) {
			case 0 : { return -1; }
			case 2 : { return  1; }
			default: { return  0; }
		}
	}
	
	private boolean isPass(char temp) {
		return ((temp != Terrain.WTR) && (temp != Terrain.MNT) && (!Bug.isBug(temp))) ? true : false;
	}
	
	private float motivate(char temp, int depth) {
		float motivation = 0;
		
		if (this.getFood() < this.getMateLevel())
			motivation = ((float)(this.getThingAt(temp))) / (float)depth;
		else if (temp == this.getRace())
			motivation = ((float)(this.getThingAt(temp))) / (float)depth;
		else
			motivation = ((float)(this.getThingAt(temp))) / (float)(depth * 2);
		
		if ((motivation < 0) && (temp == Food.FOOD3))
			return 0;
		
		return motivation;
	}
	
	private float look_b(VirtualScreen screen, int depth, int vec, int yo, int xo) {
		float weight = 0;
		final int world_row = screen.getHeight(), world_col = screen.getWidth();
		char temp;
		
		temp = screen.getCharAt( (this.getYpos() + world_row + yo) % world_row,
								 (this.getXpos() + world_col + xo) % world_col );
		if (isPass(temp) && (depth < this.getFov())) {
			weight += look_b(screen,depth+1,vec,yo + look_c(vec+0), xo + look_c(vec+1));
			if (depth < (this.getFov() - 1)) {
				look_b(screen,depth+1,vec+1,yo,xo);
				look_b(screen,depth+1,vec+3,yo,xo);
			}
		}
		
		return weight;
	}
}
