package jbugs.devices;

import jbugs.land.Terrain;

public class VirtualScreen {
	
	/**
	 * Virtual screen width
	 */
	private int width;
	/**
	 * Virtual screen height
	 */
	private int height;
	
	/**
	 * Virtual 'screen' that gets manipulated. Two dimensional array of characters
	 */
	private StringBuffer[] screen; 
	
	/**
	 * Creates a new virtual screen with a default width & height
	 */ 
	public VirtualScreen() {
		width = 80;
		height = 25;
		screen = new StringBuffer[height];
		for (int x=0; x < height; x++) {
			screen[x] = new StringBuffer(width);
			for (int y=0; y < width; y++)
				screen[x].append(Terrain.SPC);
		}
	}
	
	/**
	 * Creates a new virtual screen of size new_width x new_height
	 * @param	new_width	Width of the virtual screen
	 * @param	new_height	Height of the virtual screen
	 */
	public VirtualScreen(int new_width, int new_height) {
		width = new_width;
		height = new_height;
		screen = new StringBuffer[height];
		for (int x=0; x < height; x++) {
			screen[x] = new StringBuffer(width);
		for (int y=0; y < width; y++)
				screen[x].append(Terrain.SPC);
		}
	}
	
	/**
	 * Returns the width of the virtual screen
	 */
	public int getWidth() {
		return width;
	}
	
	/**
	 * Returns the height of the virtual screen
	 */
	public int getHeight() {
		return height;
	}
	
	/**
	 * Retrive a character from the 'world' at position yf,xf
	 * @param	yf	y coordinate
	 * @param	xf	x coordinate
	 */
	public char getCharAt(int yf, int xf) {
		return screen[yf].charAt(xf);
	}
	
	public void setCharAt(int yf, int xf, char data) {
		screen[yf].setCharAt(xf,data);
	}
	
	public String getRowString(int y) {
		return (screen[y]).toString();
	}
	
	public void pad() {
		int result;
		
		for (int y=0; y<height; y++) {
			result = width - screen[y].length();
			if (result > 0) {
				for (int x=0; x < result; x++)
					screen[y].append("+");
			}
		}
	}	
}
