import jbugs.ui.BugFrame;
import jbugs.devices.VirtualScreen;
import jbugs.land.Terrain;
import jbugs.resources.Food;
import jbugs.lifeforms.Bug;
import jbugs.utils.BugMath;

import java.lang.Thread;

public class JBugs implements Runnable {
	
	private BugFrame bug_frame;
	private VirtualScreen screen;
	private Terrain terrain;
	private Food food;
	private int num_bugs;
	private Bug bugs;
	private Bug first;
	private Bug sb;
	private Bug hf;
	private Bug hg;
	private Bug old;
	private Bug hk; 
	private int fg;
	private int dm;
	private int tmpr;
	private int tmpc;
	
	public JBugs() {
		bug_frame = new BugFrame();
		bugs = null;
		fg = 0;
		dm = 0;
		tmpr = 0;
		tmpc = 0;
	}

	public void initWorld() {
		
		int grid_size = 4;
		int roughness = 100;
		/* Set things up */
		System.out.println("In the beginning, there was void....");
		screen = new VirtualScreen();
		bug_frame.setVirtualScreens(screen);
		System.out.println("So; we made a world. And it was good....");
		System.out.println("Then; we introduce chaos....");
		/* Generate the terrain */
		terrain = new Terrain();
		terrain.setVirtualScreen(screen);
		terrain.generateTerrain(grid_size,roughness);
		System.out.println("The mountains and waters formed. And they were good....");
		/* Place food */
		food = new Food();
		food.setVirtualScreen(screen);
		for (int temp = 0; temp < food.getNumFood(); temp++) {
			food.placeFood();
		}
		System.out.println("Soon plants started to grow....");
	}

	public void createLife() {
		int loop, loop2;
		final int world_col = screen.getWidth(), world_row = screen.getHeight();
		Bug temp_bug;
		
		/* Create bugs! */
		num_bugs = (int)(screen.getWidth() * screen.getHeight() * 0.01);
		
		System.out.println("And bugs appeared....");
		
		for (loop = 1; loop <= num_bugs; loop++) {
			temp_bug = new Bug();
			temp_bug.setRace((char)(BugMath.getRandom((int)Bug.L_RACE,(int)Bug.H_RACE)));
			/* Don't put bugs on a MNT or in WTR */
			do {
				temp_bug.setXpos(BugMath.getRandom(0,world_col-1));
				temp_bug.setYpos(BugMath.getRandom(0,world_row-1));
			}
			while (screen.getCharAt(temp_bug.getYpos(),temp_bug.getXpos()) != Terrain.SPC);
			
			screen.setCharAt(temp_bug.getYpos(),temp_bug.getXpos(),temp_bug.getRace());
			
			temp_bug.setVector(BugMath.getRandom(Bug.WAIT,Bug.FORWARD));
			temp_bug.setSize(BugMath.getRandom(Bug.L_SIZE,Bug.H_SIZE));
			temp_bug.setAttack(BugMath.getRandom(Bug.L_SKILL,Bug.H_SKILL)/2);
			temp_bug.setDefend(BugMath.getRandom(Bug.L_SKILL,Bug.H_SKILL)/2);
			
			while ((temp_bug.getAttack() + temp_bug.getDefend()) > temp_bug.getSize()) {
				temp_bug.setAttack(temp_bug.getAttack()-1);
				if (temp_bug.getAttack() < Bug.L_SKILL)
					temp_bug.setAttack(Bug.L_SKILL);
				temp_bug.setDefend(temp_bug.getDefend()-1);
				if (temp_bug.getDefend() < Bug.L_SKILL)
					temp_bug.setDefend(Bug.L_SKILL);
			}
			
			temp_bug.setFov( (int)(Math.sqrt(temp_bug.getSize())) );
			if (temp_bug.getFov() > Bug.H_FOV)
				temp_bug.setFov(Bug.H_FOV);
			temp_bug.setFood(10000);
			temp_bug.setGeneration(1);
			temp_bug.setAge(0);
			
			for (loop2 = 0; loop2 < Bug.THINGS_SIZE; loop2++) {
				if (temp_bug.isBug((char)loop2)) {
					temp_bug.setThingAt(loop2,BugMath.getRandom(-Bug.ID,Bug.ID));
				} else {
					temp_bug.setThingAt(loop2,0);
				}
			} // loop2
			
			temp_bug.setThingAt(Food.FOOD3,Food.FOOD_VAL);
			if (loop == 1) {
				bugs = temp_bug;
			}
			temp_bug.addToList();
		} // for loop
		first = bugs;
		sb = bugs;
		hf = bugs;
		hg = bugs;
		old = bugs;
		hk = bugs;
		System.out.println("They ate plants and sometimes; each other....");
		System.out.println("They began to breed and evolve....");
		bug_frame.setVisible(true);
	}

	public void run() {
		final int world_row = screen.getHeight(), world_col = screen.getWidth();
		
		while (true) {
			/* First bug has to check some stuff out */
			if (bugs == first) {
				/* Show this frame */
				switch(dm) {
					case 0 : {
						//display(tmpr,tmpc);
						break;
					}
					case 1 : {
						//stat(0);
						break;
					}
					case 2 : {
						//stat(1);
						break;
					}
					case 3 : {
						//stat(2);
						break;
					}
					case 4 : {
						//stat(3);
						break;
					}
					default : {
						System.out.println("Oops .. Bad display mode");
						break;
					}
				} // switch
				/* Grow food */
				fg = ++fg % Food.FOOD_GROW;
			} /* End first bug */
			if (fg == 0) {
				/* Grow some food */
				if (bugs == first) {
					food.growFood();
				}
				
				/* Get older */
				bugs.setAge(bugs.getAge()+1);
				
				/* Did the bug eat a lot? */
				if (bugs.getFood() >= bugs.getSplitLevel()) {
					bugs.mate(screen);
				}
				/* Keep track of special bugs */
				if (bugs.getFood() > hf.getFood()) {
					hf = bugs;
				}
				if (bugs.getGeneration() > hg.getGeneration()) {
					hg = bugs;
				}
				if (bugs.getAge() > old.getAge()) {
					old = bugs;
				}
				if (bugs.getThingAt(Food.FOOD3) < hk.getThingAt(Food.FOOD3)) {
					hk = bugs;
				}
				/* Did the bug starve to death? */
				if (bugs.getFood() <= 0) {
					if (sb == bugs) {
						bugs = bugs.getNextBug();
						bugs.die(screen);
						/* Clean house */
						System.gc();
					}
				} 
						
			} // end other stuff
			bugs = bugs.getNextBug();
			screen.setCharAt(bugs.getYpos(),bugs.getXpos(),Terrain.SPC);
			/* What is the bug doing? */
			switch (bugs.look(screen)) {
				case Bug.WAIT : {
					bugs.setFood(bugs.getFood() - bugs.getWaitF());
					break;
				}
				case Bug.RIGHT : {
					bugs.setFood(bugs.getFood() - bugs.getTurnF());
					bugs.setVector((bugs.getVector()+1)%4);
					break;
				}
				case Bug.LEFT : {
					bugs.setFood(bugs.getFood() - bugs.getTurnF());
					bugs.setVector((bugs.getVector()+3)%4);
					break;
				}
				case Bug.FORWARD : {
					bugs.setFood(bugs.getFood() - bugs.getMoveF());
					switch(bugs.getVector()) {
						case Bug.SCREEN_UP : {
							bugs.setYpos(bugs.getYpos()-1);
							bugs.setYpos( (bugs.getYpos() + world_row) % world_row );
							break;
						}
						case Bug.SCREEN_RIGHT : {
							bugs.setXpos(bugs.getXpos()+1);
							bugs.setXpos(bugs.getXpos() % world_col );
							break;
						}
						case Bug.SCREEN_DOWN : {
							bugs.setYpos( bugs.getYpos() + 1 );
							bugs.setYpos( bugs.getYpos() % world_row );
							break;
						}
						case Bug.SCREEN_LEFT : {
							bugs.setXpos( bugs.getXpos() - 1 );
							bugs.setXpos( (bugs.getXpos() + world_col) % world_col );
							break;
						}
						default : {
							System.out.println("default in main inner bug vector is bad");
							break;
						}
					} // Switch
					break;
				}
				default : {
					System.out.println("Default in main look returned a bad value");
					break;
				}
			} /* Bug done */
			
			screen.setCharAt(bugs.getYpos(),bugs.getXpos(),bugs.getRace());
			/* Delay */
			try {
			
			Thread.sleep(100);
			}
			catch (InterruptedException e) { System.out.println("We were interrupted!"); 
											 System.out.println(e.toString());
										   }
			/* Now that the screen has been 'redrawn', update the UI */
			
			bug_frame.rePaint(); 
		}
	}

	public static void main(String[] args) {
		JBugs jBugs = new JBugs();
		jBugs.initWorld();
		jBugs.createLife();
		jBugs.run();
	}		
}
