/*
 * Copyright James Morse Y2K +1, +2
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <stdlib.h>
#include "bug6.h"
#include "terrain.h"
#include "food.h"

/* scan world ... 
 * move food to the next state 
 * porpogate the patch 
 */
void growfood(void)
{
	int xf, yf;
	
	for (xf = 0; xf < world_col; xf++)
		for (yf = 0; yf < world_row; yf++)
		{
			if (world[world_col * yf + xf] == FOOD2)
				world[world_col * yf + xf] = FOOD4;
	
			if (world[world_col * yf + xf] == FOOD1)
				world[world_col * yf + xf] = FOOD2;
		}
	
	for (xf = 0; xf < world_col; xf++)
		for (yf = 0; yf < world_row; yf++)
		{
			if (world[world_col * yf + xf] == FOOD3)
			{
				if (world[world_col * ((yf - 1 + world_row) % world_row) + xf] == SPC)
					world[world_col * ((yf - 1 + world_row) % world_row) + xf] = FOOD1;

				if (world[world_col * yf + ((xf + 1) % world_col)] == SPC)
					world[world_col * yf + ((xf + 1) % world_col)] = FOOD1;

				if (world[world_col * ((yf + 1) % world_row) + xf] == SPC)
					world[world_col * ((yf + 1) % world_row) + xf] = FOOD1;

				if (world[world_col * yf + ((xf - 1 + world_col) % world_col)] == SPC)
					world[world_col * yf + ((xf - 1 + world_col) % world_col)] = FOOD1;
			}
		}

	for (xf = 0; xf < world_col; xf++)
		for (yf = 0; yf < world_row; yf++)
			if (world[world_col * yf + xf] == FOOD4)
				world[world_col * yf + xf] = FOOD3;
	
	return;
}

/* randomly locate a new food */
void placefood(void)
{
	int x, y;
	
	if (getrandom(0, FOOD_RATE) > 1)
		return;
		
	y = getrandom(0, world_row - 1);
	x = getrandom(0, world_col - 1);
	
	if (world[world_col * y + x] == SPC)
		world[world_col * y + x] = FOOD1;
	
	return;
}