/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <curses.h>
#include "bug6.h"

void view_t (struct bug *vb)
{
	int temp;
	int thing_c = 0;
	int thing_l = 1;
	/* anchor for pop up */
	WINDOW *popup_window_ptr;

	/* Add pop up window */
	/* 9 lines x 35 cols @ line 2 , col 2 */
	popup_window_ptr = newwin (9, 35, 2, 2);
	/* with a box around it */	
	box (popup_window_ptr, '|', '-');
	
	/* print stuff */
	for (temp = 0; temp < 256; temp++)
	{
		if (vb->things[temp] != 0)
		{
			mvwprintw (popup_window_ptr, thing_l, 2 + (thing_c % 4) * 8, "%c %+4.4i ", (char)temp, vb->things[temp]);
			thing_c++;
			if ((thing_c % 4 == 0) && (thing_c > 0))
				thing_l++;
		}
	}
	
	/* show it */
	wrefresh (popup_window_ptr);
	sleep (10);

	/* delete the popup window */
	delwin (popup_window_ptr);

	return;
}