/*
 *  Copyright James Morse Y2K+1   please read COPYING
 *
 *  Questions and comments may be sent to: xbeastx@writeme.com 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *
 *  Free Software Foundation, Inc.
 *  59 Temple Place, Suite 330
 *  Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "kb.h"
#include "gpl.h"
#include "food.h"
#include "bug6.h"
#include "terrain.h"
#include "look.h"
#include "error.h"

int main(int argc, char *argv[])
{
	int tmpr = 0, tmpc = 0;
	char sd = '\0';
	int temp;
	int grid_size = 4;
	int roughness = 100;
	int fg = 0;
	int dm = 0;
	int pf = 0;
	char *sbis = "";
	
	/* default world size to phyical screen */
	world_row = RROW - 5;
	world_col = RCOL;
		
	/* parse cammand line */
	if (argc > 1)
	{
		for (temp = 1; temp < argc; temp++)
		{
			/* set world size */
			if (strcmp (argv[temp], "-s") == 0)
			{
				world_row = atoi (argv[++temp]);
				world_col = atoi (argv[++temp]);
				if (!world_row || !world_col)
				{
					fprintf (stderr, "try -s [rows cols]\n");
					exit (CMDL_1);
				}
			}

			/* set roughness */
			else if (strcmp (argv[temp], "-r") == 0)
			{
				roughness = atoi (argv[++temp]);
				if ((roughness < 1) || (roughness > 1000))
				{
					fprintf (stderr, "try -r [1-1000]\n");
					exit (CMDL_2);
				}
			}

			/* set grid size */
			else if (strcmp (argv[temp], "-g") == 0)
			{
				grid_size = atoi (argv[++temp]);
				if ((grid_size < 2) || (grid_size > 8))
				{
					fprintf (stderr, "try -g [2-8]\n");
					exit (CMDL_3);
				}
			}

			/* display licnse */
			else if (strcmp (argv[temp], "-l") == 0)
			{
				gnu();
				exit(GNU_L);
			}

			/* bad user ... */
			else 
			{
				fprintf (stderr, "bad args\n");
				exit (CMDL_U);
			}
		}
	}
	
	/* setup some stuff */
	printf("In the the beginning there was void ...\n");

	/* make the world */
	if ((world = (char *)malloc(world_row * world_col)) == NULL)
	{
		printf("bad malloc ... no world!!!\n");
		exit(BM_B6);
	}
	printf("So we made a world and it was good ...\n");

	/* seed the random number generator */
 	srand((unsigned)time( NULL ));
 	printf("Then we introduced chaos ...\n");

	/* generate the terrain */
	generateterrain(grid_size, roughness);
	printf("The mountians and waters formed and they were good ...\n");

	/* place food */
	for (temp = 0 ; temp < NUM_FOOD ; temp++)
		placefood();
	printf("Soon plants started to grow ...\n");

	/* place bugs */
	start();
	printf("And bugs appeared ...\n");
	printf("\n");
	printf("They ate the plants and sometimes each other ...\n");
	printf("They began to bread and evolve ...\n");
	
	/* initalize the keyboard */
	init_kb();
	
	while(!kb_hit());
	sd = read_kb();
	sd = '\0';
	
	/* clear the screen */
	printf("%c[2J", 033);

	/* set pointers */
	first = bugs;
	sb = bugs;
	hf = bugs;
	hg = bugs;
	old = bugs;
	hk = bugs;
	
	u1mode = 2;
	u2mode = 3;
		
	/* main loop */
	for (;;)
	{
		/* first bug in loop better check out some stuff */
		if (bugs == first)
		{
			/* show this frame */
			switch(dm)
			{
				case 0: /* world display */
					display(tmpr, tmpc);
					printf("x hjklg p m-+ 12345");
					printf("\n");
					printf("%c[K", 033);
					printf("%s\t%c  Ag=%i  Fd=%i  Gn=%i  Sz=%i  At=%i  Df=%i  Fv=%i", sbis, sb->race, sb->age, sb->food, sb->gen, sb->size, sb->attack, sb->defend, sb->fov);
					break;

				case 1: /* MIN */
					stat(0);
					break;

				case 2: /* AVG */
					stat(1);
					break;

				case 3: /* MAX */
					stat(2);
					break;

				case 4: /* USER */
					stat(3);
					break;

				default:
					printf("oops .. bad display mode\n");
					dm = 0;
					break;
			}

			/* grow food? */
			fg = ++fg % FOOD_GROW;

		} /* end first bug */
		
		/* start of gorwth cycle check some other stuff */
		if (fg == 0)
		{
			/* grow some food */
			if (bugs == first)
				growfood();
		
			/* get older */
			bugs->age++;
						
			/* did bug eat lots??? */
			if (bugs->food >= SPLIT_LVL)
				mate();
				
			/* keep track of special bugs */
			if (bugs->food > hf->food)
				hf = bugs;

			if (bugs->gen > hg->gen)
				hg = bugs;

			if (bugs->age > old->age)
				old = bugs;

			if (bugs->things[FOOD3] < hk->things[FOOD3])
				hk = bugs;

			/* did bug starve to death ??? */
			if (bugs->food <= 0)
			{
				if (sb == bugs)
				sbis = "";					
				die(bugs);
			}	
		} /* end of other stuff */
			
		bugs = bugs->next;
		world[world_col * bugs->ypos + bugs->xpos] = SPC;

		/* what is bug doing??? */
		switch (look())
		{
			case WAIT: /* do nothing */
				bugs->food -= WAIT_F;
				break;

			case RIGHT: /* turn left */
				bugs->food -= TURN_F;
				bugs->vector = (bugs->vector + 1) % 4;        
				break;

			case LEFT: /* turn right */
				bugs->food -= TURN_F;
				bugs->vector = (bugs->vector + 3) % 4;
				break;

			case FORWARD: /* move ahead */
				bugs->food -= MOVE_F;
				switch (bugs->vector)
				{
					case 0:	/* screen up */
						bugs->ypos = (--bugs->ypos + world_row) % world_row;
						break;

					case 1: /* screen right */
						bugs->xpos = (++bugs->xpos) % world_col;
						break;

					case 2: /* screen down */
						bugs->ypos = (++bugs->ypos) % world_row;
						break;

					case 3: /* screen left */
						bugs->xpos = (--bugs->xpos + world_col) % world_col;
						break;                                          

					default:
						fprintf (stderr, "default in main inner bugs->vector is bad\n");
						break;
				}
				break;

			default:
				fprintf (stderr, "default in main look returned a bad value\n");
				break;
		
		} /* bug done */

		world[world_col * bugs->ypos + bugs->xpos] = bugs->race;

		do {
			/* did the user do something? */
			if (kb_hit())
				sd = read_kb();
			
			/* what is user doing? */
			switch (sd)
			{
				case '\0': /* do nothing */
					if (pf)
					{
						display(tmpr, tmpc);
						sleep(1);
					}
					break;
				
				case 'h': /* left to right */
				case 'H':
					if (--tmpc < 0)
						tmpc = world_col;
					break;
				
				case 'j': /* bottom to top */
				case 'J':
					if (++tmpr > world_row)
						tmpr = 0;
					break;
				
				case 'k': /* top to bottom */
				case 'K':
					if (--tmpr < 0)
						tmpr = world_row;
					break;
				
				case 'l': /* right to left */
				case 'L':
					if (++tmpc > world_col)
						tmpc = 0;
					break;
				
				case 'x': /* exit */
				case 'X':
					stop(EXIT_OK);
					break;
	
				case 'm': /* change display mode */
				case 'M':
					dm = ++dm % 5;
					break;

				case '-': /* user display mode panel 1 */
					u1mode = ++u1mode % 7;
					break;

				case '+': /* user display mode panel 2 */
					u2mode = ++u2mode % 7;
					break;

				case '1': // make sb = next
					sbis = "";
					sb = sb->next;
					break;

				case '2': // make sb = high food
					sbis = "hf";
					sb = hf;
					break;

				case '3': // make sb = high gen
					sbis = "hg";
					sb = hg;
					break;

				case '4': // make sb = oldest
					sbis = "old";
					sb = old;
					break;

				case '5': // make sb = highest kills
					sbis = "hk";
					sb = hk;
					break;

				case 'g': // snap screen to sb
				case 'G':
					tmpr = (sb->ypos - (RROW / 2) + world_row) % world_row;
					tmpc = (sb->xpos - (RCOL / 2) + world_col) % world_col;
					break;

				case 'p': /* pause */
				case 'P':
					pf = !pf;
					break;
								
				default: /* Bad user ... No biscut!!! */
					printf("bad key");
					break;
			}
			sd = '\0';

		} while(pf);
	}
	
	/* ooops ... */
	printf("we should never exit this way\n");
	stop(EXIT_1);
	/* and evan if we do, we never get here */
	return(EXIT_2);
}

/* safe stop */
void stop(int ec)
{
	/* restore keyborad */
	close_kb();
	printf("\nThank plaese come again ...\n");
	exit(ec);
}
