/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <stdio.h>
#include "bug6.h"
#include "food.h"
#include "terrain.h"
#include <limits.h>
#include <stdlib.h>

#define COLOR /* we want colors? ... */

#define MIN 0
#define AVG 1
#define MAX 2

struct counts
{ 
	int pop;
	char race;
	int age[3];
	int food[3];
	int gen[3];
	int size[3];
	int attack[3];
	int defend[3];
	int fov[3];
};

void display(int srow, int scol)
{
	int tmpr, tmpc;
	char nl = '\n';
	
	#ifdef COLOR
		char buf[10];
	#endif
		
	/* are the args sane? */
	if ((srow < 0)||(srow > world_row)||(scol < 0)||(scol > world_col))
	{
		printf("\n");
		printf("bad args passsed to display");
		printf("\n");
		return;
	}		

	/* prep physical screen */
	printf("%c[H", 033);

	/* display desired area with wrapping */
	/* - 5 room for msg display area */
	for (tmpr = 0 ; (tmpr < RROW - 5)&&(tmpr < world_row) ; tmpr++)
	{
		for (tmpc = 0 ; (tmpc < RCOL)&&(tmpc < world_col) ; tmpc++)
		{
			int r, c;
			r = world_col * ((srow + tmpr) % world_row);
			c = (scol + tmpc) % world_col;

			#ifdef COLOR
				switch(world[r + c])
				{
					case FOOD1: /* small food green */
					case FOOD2: /* medium food green */
						buf[0] = 033;
						buf[1] = '[';
						buf[2] = '0';
						buf[3] = ';';
						buf[4] = '3';
						buf[5] = '2';
						buf[6] = 'm';
						buf[7] = world[r + c];
						buf[8] = '\0';
						break;
	
					case FOOD3: /* large food bright green */
						buf[0] = 033;
						buf[1] = '[';
						buf[2] = '1';
						buf[3] = ';';
						buf[4] = '3';
						buf[5] = '2';
						buf[6] = 'm';
						buf[7] = world[r + c];
						buf[8] = '\0';
						break;

					case WTR: /* water blue */
						buf[0] = 033;
						buf[1] = '[';
						buf[2] = '0';
						buf[3] = ';';
						buf[4] = '3';
						buf[5] = '4';
						buf[6] = 'm';
						buf[7] = world[r + c];
						buf[8] = '\0';
						break;

					case MNT: /* mountain purple */
						buf[0] = 033;
						buf[1] = '[';
						buf[2] = '0';
						buf[3] = ';';
						buf[4] = '3';
						buf[5] = '5';
						buf[6] = 'm';
						buf[7] = world[r + c];
						buf[8] = '\0';
						break;
					
					default: /* its a bug or SPC white */
						buf[0] = 033;
						buf[1] = '[';
						buf[2] = '0';
						buf[3] = 'm';
						buf[4] = world[r + c];
						buf[5] = '\0';
						break;
				}

				fwrite(buf, 1, strlen(buf), stdout);
			#else
				fwrite(&world[r + c], 1, 1, stdout);
			#endif
		
		}

		/* did we hit the egde? */
		if (tmpc < RCOL)
			fwrite(&nl, 1, 1, stdout);
	}

	#ifdef COLOR
		/* set normal color */
		buf[0] = 033;
		buf[1] = '[';
		buf[2] = '0';
		buf[3] = 'm';
		buf[4] = '\0';
		fwrite(buf, 1, strlen(buf), stdout);
	#endif
	
	/* force update */
	fflush(stdout);

	/* build menu area */
	for (tmpc = 0 ; tmpc < RCOL ; tmpc++)
		printf("=");

	printf("\n");			
	printf("x hjkl m");
	printf("\n");			

	return;
}

/* display panel for USER stats */
void u_panel (struct counts *race, int umode)
{
	switch (umode)
	{
		case 0:
			printf("%i	%i	%i	", race->age[MIN], race->age[AVG], race->age[MAX]);
			break;
		case 1:
			printf("%i	%i	%i	", race->food[MIN], race->food[AVG], race->food[MAX]);
			break;
		case 2:
			printf("%i	%i	%i	", race->gen[MIN], race->gen[AVG], race->gen[MAX]);
			break;
		case 3:	
			printf("%i	%i	%i	", race->size[MIN], race->size[AVG], race->size[MAX]);
			break;
		case 4:
			printf("%i	%i	%i	", race->attack[MIN], race->attack[AVG], race->attack[MAX]);
			break;
		case 5:
			printf("%i	%i	%i	", race->defend[MIN], race->defend[AVG], race->defend[MAX]);
			break;
		case 6:
			printf("%i	%i	%i	", race->fov[MIN], race->fov[AVG], race->fov[MAX]);
			break;
		default:
			break;
	}
	
	return;
}

/* qsort helper funtion */
int cmp_race (const void *i1, const void *i2)
{
	return ((* (struct counts *) i2).pop - (* (struct counts *) i1).pop);
}

/* start in known sane state */
void init_counts (struct counts *temp)
{
	temp->pop = 0;

	temp->age[MIN] = INT_MAX;
	temp->age[AVG] = 0;
	temp->age[MAX] = INT_MIN;

	temp->food[MIN] = INT_MAX;
	temp->food[AVG] = 0;
	temp->food[MAX] = INT_MIN;

	temp->gen[MIN] = INT_MAX;
	temp->gen[AVG] = 0;
	temp->gen[MAX] = INT_MIN;

	temp->size[MIN] = INT_MAX;
	temp->size[AVG] = 0;
	temp->size[MAX] = INT_MIN;

	temp->attack[MIN] = INT_MAX;
	temp->attack[AVG] = 0;
	temp->attack[MAX] = INT_MIN;

	temp->defend[MIN] = INT_MAX;
	temp->defend[AVG] = 0;
	temp->defend[MAX] = INT_MIN;

	temp->fov[MIN] = INT_MAX;
	temp->fov[AVG] = 0;
	temp->fov[MAX] = INT_MIN;

	return;
}

void stat(int mam)
{
	struct bug *temp1 = bugs;
	struct counts races[256];
	int temp;
	char *smam;
	char *ustat[7] = {"age", "food", "gen", "size", "attack", "defend", "fov"};

	printf("%c[2J", 033); /* CLS  */
	printf("%c[H", 033);  /* Home */
	
	for (temp = 0; temp < 256; temp++)
	{
		init_counts (&races[temp]);
		races[temp].race = temp;
	}

	do
	{
		races[0].age[AVG] += temp1->age;
		races[0].food[AVG] += temp1->food;
		races[0].gen[AVG] += temp1->gen;
		races[0].size[AVG] += temp1->size;
		races[0].attack[AVG] += temp1->attack;
		races[0].defend[AVG] += temp1->defend;
		races[0].fov[AVG] += temp1->fov;

		races[(int)temp1->race].pop++;

		if (temp1->age < races[(int)temp1->race].age[MIN])
			races[(int)temp1->race].age[MIN] = temp1->age;
		races[(int)temp1->race].age[AVG] += temp1->age;
		if (temp1->age > races[(int)temp1->race].age[MAX])
			races[(int)temp1->race].age[MAX] = temp1->age;

		if (temp1->food < races[(int)temp1->race].food[MIN])
			races[(int)temp1->race].food[MIN] = temp1->food;
		races[(int)temp1->race].food[AVG] += temp1->food;
		if (temp1->food > races[(int)temp1->race].food[MAX])
			races[(int)temp1->race].food[MAX] = temp1->food;

		if (temp1->gen < races[(int)temp1->race].gen[MIN])
			races[(int)temp1->race].gen[MIN] = temp1->gen;
		races[(int)temp1->race].gen[AVG] += temp1->gen;
		if (temp1->gen > races[(int)temp1->race].gen[MAX])
			races[(int)temp1->race].gen[MAX] = temp1->gen;

		if (temp1->size < races[(int)temp1->race].size[MIN])
			races[(int)temp1->race].size[MIN] = temp1->size;
		races[(int)temp1->race].size[AVG] += temp1->size;
		if (temp1->size > races[(int)temp1->race].size[MAX])
			races[(int)temp1->race].size[MAX] = temp1->size;

		if (temp1->attack < races[(int)temp1->race].attack[MIN])
			races[(int)temp1->race].attack[MIN] = temp1->attack;
		races[(int)temp1->race].attack[AVG] += temp1->attack;
		if (temp1->attack > races[(int)temp1->race].attack[MAX])
			races[(int)temp1->race].attack[MAX] = temp1->attack;

		if (temp1->defend < races[(int)temp1->race].defend[MIN])
			races[(int)temp1->race].defend[MIN] = temp1->defend;
		races[(int)temp1->race].defend[AVG] += temp1->defend;
		if (temp1->defend > races[(int)temp1->race].defend[MAX])
			races[(int)temp1->race].defend[MAX] = temp1->defend;

		if (temp1->fov < races[(int)temp1->race].fov[MIN])
			races[(int)temp1->race].fov[MIN] = temp1->fov;
		races[(int)temp1->race].fov[AVG] += temp1->fov;
		if (temp1->fov > races[(int)temp1->race].fov[MAX])
			races[(int)temp1->race].fov[MAX] = temp1->fov;

		temp1 = temp1->next;
		races[0].pop++;
	}
	while (temp1 != bugs);	
	
	for (temp = 0; temp < 256; temp++)
		if(races[temp].pop != 0)	
		{
			races[temp].age[AVG] /= races[temp].pop;
			races[temp].food[AVG] /= races[temp].pop;
			races[temp].gen[AVG] /= races[temp].pop;
			races[temp].size[AVG] /= races[temp].pop;
			races[temp].attack[AVG] /= races[temp].pop;
			races[temp].defend[AVG] /= races[temp].pop;
			races[temp].fov[AVG] /= races[temp].pop;
		}
		     
	qsort (races, 256, sizeof (struct counts), cmp_race);

	switch (mam)
	{
		case MIN:
			smam = "MIN";
			break;
		case AVG:
			smam = "AVG";
			break;
		case MAX:
			smam = "MAX";
			break;
		default:
			smam = "USER";
			break;
	}

//	printf("Status -- %i/%i -- %.2f -- %i -- %s -- %s -- %s --\n", roughness, grid_size, world_size, VER, __DATE__, __TIME__, smam);

	printf("race	pop	age	food	gen	size	attack	defend	fov\n");
	printf("all	%i	%i	%i	%i	%i	%i	%i	%i\n", races[0].pop, races[0].age[AVG], races[0].food[AVG], races[0].gen[AVG], races[0].size[AVG], races[0].attack[AVG], races[0].defend[AVG], races[0].fov[AVG]);

	if (mam == 3)
	{
		printf("			%s			%s\n", ustat[u1mode], ustat[u2mode]);
		printf("race	pop	MIN	AVG	MAX	MIN	AVG	MAX\n");
	}
	
	else
	{
		printf("\n");
		printf("race	pop	age	food	gen	size	attack	defend	fov\n");
	}
	
	for (temp = 1; temp < (RROW - 5); temp++)
		if (races[temp].pop > 0)
		{	
			if (mam == 3)
			{
				printf("%c	%i	", races[temp].race, races[temp].pop);
				
				u_panel (&races[temp], u1mode);
				u_panel (&races[temp], u2mode);
				
				printf("\n");
			}	
			else
				printf("%c	%i	%i	%i	%i	%i	%i	%i	%i\n", races[temp].race, races[temp].pop, races[temp].age[mam], races[temp].food[mam], races[temp].gen[mam], races[temp].size[mam], races[temp].attack[mam], races[temp].defend[mam], races[temp].fov[mam]);
		}
	return;
}

