/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <stdio.h>
#include "bug6.h"

void display(int srow, int scol)
{
	int tmpr, tmpc;
	
	/* are the args sane? */
	if ((srow < 0)||(srow > world_row)||(scol < 0)||(scol > world_col))
	{
		printf("\n");
		printf("bad args passsed to display");
		printf("\n");
		return;
	}		

	/* prep physical screen */
	printf("%c[H", 033);

	/* display desired area with wrapping */
	/* - 5 room for msg display area */
	for (tmpr = 0 ; (tmpr < RROW - 5)&&(tmpr < world_row) ; tmpr++)
	{
		for (tmpc = 0 ; (tmpc < RCOL)&&(tmpc < world_col) ; tmpc++)
		{
			int r, c;
			r = world_col * ((srow + tmpr) % world_row);
			c = (scol + tmpc) % world_col;
		//	putchar(world[r + c]);
			fwrite(&world[r + c], 1, 1, stdout);
		//	printf("%c", world[r + c]);
		}
		/* did we hit the egde? */
		if (tmpc < RCOL)
			putchar('\n');
	}
	fflush(stdout);

	for (tmpc = 0 ; tmpc < RCOL ; tmpc++)
		printf("=");
	printf("\n");			
	printf("x hjkl");
	printf("\n");			
	return;
}
