/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

// Bug6 header file
#ifndef BUG6_H
#define BUG6_H 

/* virtual world */
int world_row;
int world_col;
char *world;

/* size of physical display */
#define RROW 25
#define RCOL 80

void stop(int);
void display(int, int);
struct bug* findbug (int, int);
void die (struct bug *);
void mate (void);

#define getrandom( min, max ) ((rand() % (int) (((max) + 1) - (min))) + (min))

// used to set intial condition in start() ...
#define NUM_BUGS (world_col * world_row * .01)

// bug food val factor
// biten->size * BUG_FOOD * FOOD_VAL
#define BUG_FOOD 6

// how much food is used in mateing
#define MATE_COST (FOOD_VAL * bugs->size)
// how much food required to mate
#define MATE_LVL (4 * MATE_COST)
// how much food is need to split
#define SPLIT_LVL (MATE_LVL * 2)

// racial forgetfulness
#define RF (3 / 4)
// noise to foster learning
#define ID 5

// what races?
#define L_RACE 'A'
#define H_RACE 'Z'

// what sizes?
#define L_SIZE 2
#define H_SIZE 100
#define D_SIZE 10

// what skills?
#define L_SKILL 0
#define H_SKILL 100
#define D_SKILL 10

// what fov?
#define L_FOV 1
#define H_FOV 10

// a bug does what ???
#define WAIT 0
#define LEFT 1
#define RIGHT 2
#define FORWARD 3
// and uses some food
#define UFF (1 + sqrt(bugs->size))
#define WAIT_F UFF
#define TURN_F (1.4 * UFF)
#define MOVE_F (2 * UFF)

// the bug structure
struct bug
{
	int xpos, ypos, vector;  
	int food;
	char race;
	int age;
	int gen;
	int size;
	int attack;
	int defend;
	int fov;
	int things[256];
	struct bug *prev;
	struct bug *next;
};

// current & "first"
struct bug *bugs, *first;

// status, highfood, high gen, oldest bugs ...
struct bug *sb, *hf, *hg, *old, *hk;

void start (void);

#endif /* BUG6_H */
