/*
 *  Copyright James Morse Y2K+1   please read COPYING
 *
 *  Questions and comments may be sent to: xbeastx@writeme.com 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the 
 *
 *  Free Software Foundation, Inc.
 *  59 Temple Place, Suite 330
 *  Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "kb.h"
#include "gpl.h"
#include "food.h"
#include "bug6.h"
#include "terrain.h"
#include "look.h"
#include "error.h"

int main(int argc, char *argv[])
{
	int tmpr = 0, tmpc = 0;
	char sd = '\0';
	int temp;
	int grid_size = 4;
	int roughness = 100;
	int fg = 0;
	int cpuwait = 1; // this is to slow down the bugs ... higher is slower


	/* default world size to phyical screen */
	world_row = RROW - 5;
	world_col = RCOL;
		
	/* parse cammand line */
	printf("Parsing command line ...\n");
	if (argc > 1)
	{
		for (temp = 1; temp < argc; temp++)
		{
			/* set world size */
			if (strcmp (argv[temp], "-s") == 0)
			{
				world_row = atoi (argv[++temp]);
				world_col = atoi (argv[++temp]);
				if (!world_row || !world_col)
				{
					fprintf (stderr, "try -s [rows cols]\n");
					exit (CMDL_1);
				}
			}

			/* set roughness */
			else if (strcmp (argv[temp], "-r") == 0)
			{
				roughness = atoi (argv[++temp]);
				if ((roughness < 1) || (roughness > 1000))
				{
					fprintf (stderr, "try -r [1-1000]\n");
					exit (CMDL_2);
				}
			}

			/* set grid size */
			else if (strcmp (argv[temp], "-g") == 0)
			{
				grid_size = atoi (argv[++temp]);
				if ((grid_size < 2) || (grid_size > 8))
				{
					fprintf (stderr, "try -g [2-8]\n");
					exit (CMDL_3);
				}
			}

			/* display licnse */
			else if (strcmp (argv[temp], "-l") == 0)
			{
				gnu();
				exit(GNU_L);
			}

			/* bad user ... */
			else 
			{
				fprintf (stderr, "bad args\n");
				exit (CMDL_U);
			}
		}
	}
	
	/* setup some stuff */
	printf("Malloc world ...\n");
	/* make the world */
	if ((world = (char *)malloc(world_row * world_col)) == NULL)
	{
		printf("bad malloc ... no world!!!\n");
		exit(BM_B6);
	}

	/* seed the random number generator */
	printf("Seed rand ...\n");
 	srand ((unsigned) time ( NULL ));

	/* generate the terrain */
	printf("Making world ...\n");
	generateterrain (grid_size, roughness);

	/* initalize the keyboard */
	printf("Init kb ...\n");
	init_kb();

	/* place food */
	printf("Placeing food ...\n");
	for (temp = 0 ; temp < NUM_FOOD ; temp++)
		placefood();

	/* place bugs */
	printf("Placeing bugs ...\n");
	start();

	/* clear the screen */
	printf("%c[2J", 033);

	/* set pointers */
	first = bugs;
	sb = bugs;
	hf = bugs;
	hg = bugs;
	old = bugs;
	hk = bugs;
		
	/* main loop */
	for (;;)
	{
		// first bug in loop better check out some stuff
		if (bugs == first)
		{
			/* show this frame */
			display(tmpr, tmpc);
		
			// be nice to the processor
			if (cpuwait)
				usleep (cpuwait);

			// grow food?
			fg = ++fg % FOOD_GROW;
		} // end first bug
		
		// start of gorwth cycle check some other stuff
		if (fg == 0)
		{
			// grow some food
			if (bugs == first)
				growfood ();
		
			// get older
			bugs->age++;
						
			// did bug eat lots???
			if (bugs->food >= SPLIT_LVL)
				mate ();
				
			// keep track of special bugs
			if (bugs->food > hf->food)
				hf = bugs;

			if (bugs->gen > hg->gen)
				hg = bugs;

			if (bugs->age > old->age)
				old = bugs;

			if (bugs->things[FOOD3] < hk->things[FOOD3])
				hk = bugs;

			// did bug starve to death ???
			if (bugs->food <= 0)
			{
				if (sb == bugs)
				die (bugs);
			}	
		} // end of other stuff
			
		bugs = bugs->next;
		world[world_col * bugs->ypos + bugs->xpos] = SPC;

		// what is bug doing???
		switch (look ())
		{
			case WAIT: // do nothing
				bugs->food -= WAIT_F;
				break;

			case RIGHT: // turn left
				bugs->food -= TURN_F;
				bugs->vector = (bugs->vector + 1) % 4;        
				break;

			case LEFT: // turn right
				bugs->food -= TURN_F;
				bugs->vector = (bugs->vector + 3) % 4;
				break;

			case FORWARD: // move ahead
				bugs->food -= MOVE_F;
				switch (bugs->vector)
				{
					case 0:	// screen up
						bugs->ypos = (--bugs->ypos + world_row) % world_row;
						break;

					case 1: // screen right
						bugs->xpos = (++bugs->xpos) % world_col;
						break;

					case 2: //screen down
						bugs->ypos = (++bugs->ypos) % world_row;
						break;

					case 3: // screen left
						bugs->xpos = (--bugs->xpos + world_col) % world_col;
						break;                                          

					default:
						fprintf (stderr, "default in main inner bugs->vector is bad\n");
						break;
				}
				break;

			default:
				fprintf (stderr, "default in main look returned a bad value\n");
				break;
		} // bug done

		world[world_col * bugs->ypos + bugs->xpos] = bugs->race;

		/* did the user do something? */
		if (kb_hit())
			sd = read_kb();
			
		/* what are doing? */
		switch (sd)
		{
			case '\0': /* do nothing */
				break;
				
			case 'h': /* left to right */
				if (--tmpc < 0)
					tmpc = world_col;
				break;
				
			case 'j': /* bottom to top */
				if (++tmpr > world_row)
					tmpr = 0;
				break;
				
			case 'k': /* top to bottom */
				if (--tmpr < 0)
					tmpr = world_row;
				break;
				
			case 'l': /* right to left */
				if (++tmpc > world_col)
					tmpc = 0;
				break;
				
			case 'x': /* exit */
				stop(EXIT_OK);
				break;
				
			default: /* bad user ... */
				printf("bad key");
				break;
		}
		sd = '\0';
	}
	
	/* ooops ... */
	printf("we should never exit this way\n");
	stop(EXIT_1);
	/* and evan if we do, we never get here */
	return(EXIT_2);
}

/* safe stop */
void stop(int ec)
{
	/* restore keyborad */
	close_kb();
	
	exit(ec);
}
