#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

int child()
{
	int tmp;

	for(tmp = 1; tmp <= 10; tmp++)
	{
		printf("child %d\n", tmp);
		sleep(2);
	}
}

int main()
{
	pid_t pid;
	int c_stat;
	
	if ((pid = fork()) < 0)
	{
		/* oops */
		printf("failed to fork\n");
		exit(1);
	}

	else if (pid == 0)
	{
		/* child only */
		printf("child only\n");
		child();
		exit(0);
	}
	else
	{
		/* parent only */
		printf("parent only\n");

		while(!waitpid(pid, &c_stat, WNOHANG))
		{
			printf("wait for child to finish\n");
			sleep(5);
		}
	}

	exit(0);
}