/*
 * Copyright James Morse Y2K +1, +2, +3
 * This is GPLed software 
 * please read COPYING
 *
 * (large) portions contributed by John Campbell 
 * http://www.ci-n.com/~jcampbel
 *
 */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "bug6.h"
#include "terrain.h"
#include "error.h"

/* fractal terrain generator */
void generateterrain (int grid_size, int roughness)
{
	int *elevation_map;
	int x, y;
	int grid_s = pow(2, grid_size);
	
	if ((elevation_map = (int *)malloc(sizeof(int) * world_row * world_col)) == NULL)
	{
		fprintf(stderr, "malloc error in generateterrain\n");
		exit(BM_GT);
	}
	
	/* define primary grid */
	for (x = 0; x < world_col; x += grid_s) 
		for (y = 0; y < world_row; y += grid_s) 
			elevation_map[x + y * world_col] = getrandom(0, HEIGHT);

	for (grid_s /= 2; grid_s >= 1; grid_s /= 2) 
	{	
		/* interpolate smaller grid along horizontals */
		for (x = grid_s; x < world_col; x += grid_s * 2) 
			for (y = 0; y < world_row; y += grid_s * 2) 
				elevation_map[x + y * world_col] = getrandom(-roughness * log10(grid_s), roughness * log10(grid_s)) + (elevation_map[(x - grid_s) + y * world_col] + elevation_map[((x + grid_s < world_col) ? (x + grid_s) : (0)) + y * world_col]) / 2;
		
		/* interpolate smaller grid along verticals */
		for (x = 0; x < world_col; x += grid_s * 2) 
			for (y = grid_s; y < world_row; y += grid_s * 2) 
				elevation_map[x + y * world_col] = getrandom(-roughness * log10(grid_s), roughness * log10(grid_s)) + (elevation_map[x + (y - grid_s) * world_col] + elevation_map[x + ((y + grid_s < world_row) ? (y + grid_s) : (0)) * world_col]) / 2;
		
		/* interpolate smaller grid between gridlines */
		for (x = grid_s; x < world_col; x += grid_s * 2) 
			for (y = grid_s; y < world_row; y += grid_s * 2) 
				elevation_map[x + y * world_col] = getrandom(-roughness * log10(grid_s), roughness * log10(grid_s)) + (elevation_map[x + (y - grid_s) * world_col] + elevation_map[x + ((y + grid_s < world_row) ? (y + grid_s) : (0)) * world_col] + elevation_map[((x + grid_s < world_col) ? (x + grid_s) : (0)) + y * world_col] + elevation_map[(x - grid_s) + y * world_col]) / 4;
	}

	/* place WTR's and MNT's */
	for (x = 0; x < world_row * world_col; x++) 
	{
		if (elevation_map[x] <= WTR_LVL) 
			world[x] = WTR;
		
		else if (elevation_map[x] >= MNT_LVL) 
			world[x] = MNT;
		
		else
			world[x] = SPC;
	}
	
	free(elevation_map);

	return;
}

