/*
 * Copyright James Morse Y2K +1, +2, +3
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "terrain.h"
#include "food.h"
#include "bug6.h"
#include "look.h"
#include "error.h"

/* create intial population */
void start (void)
{
	struct bug *temp = NULL;
	struct bug *x = NULL;
	int loop, loop2;

	/* create bugs */
	for (loop = 1; loop <= NUM_BUGS; loop++)
	{
		if ((temp = (struct bug *)malloc(sizeof (struct bug))) == NULL)
		{
			fprintf(stderr, "bad malloc in start\n");
			exit(MB_ST);
		}
		temp->race = (char)getrandom(L_RACE, H_RACE);

		/* don't put bugs on MNT or in WTR */
		do {
			temp->xpos = getrandom(0, world_col - 1);
			temp->ypos = getrandom(0, world_row - 1);
		} while (world[world_col * temp->ypos + temp->xpos] != SPC);

		world[world_col * temp->ypos + temp->xpos] = temp->race;
		
		temp->vector = getrandom(0, 3);
		temp->size = getrandom(L_SIZE, H_SIZE);
		temp->attack = getrandom(L_SKILL, H_SKILL) / 2;
		temp->defend = getrandom(L_SKILL, H_SKILL) / 2;
		
		while ((temp->attack + temp->defend) > temp->size)
		{
			if (--temp->attack < L_SKILL)
				temp->attack = L_SKILL;

			if (--temp->defend < L_SKILL)
				temp->defend = L_SKILL;
		}
		
		if ((temp->fov = sqrt (temp->size)) > H_FOV)
			temp->fov = H_FOV;

		temp->food = 10000;
		temp->gen = 1;
		temp->age = 0;

		for (loop2 = 0; loop2 < 256; loop2++)
		{
			if (is_bug ((char)loop2))
				temp->things[loop2] = getrandom(-ID, ID);
			else
				temp->things[loop2] = 0;
		}
		
		temp->things[FOOD3] = FOOD_VAL;
		
		if (loop == 1)
			bugs = temp;
		else
		{
			x->next = temp;
			temp->prev = x;
		}
		
		x = temp;
	}
	
	temp->next = bugs;
	bugs->prev = temp;
	
	return;
}

