#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/socket.h>

int listener;
int client;
char name[127] = {'\0'};

void signal_handler(int signum)
{
	switch (signum)
	{
		case SIGINT:
			printf("\nRecived interrupt signal. Exiting.\n");
			close(client);
			close(listener);
			exit(0);
		default:
			printf("\nUnknown signal recieved. Ignoring.\n");
	}
}

int main(int argc, char *argv[])
{
	char dotted_ip[15];
	int port;
	struct sockaddr_in sa;
	socklen_t sa_len = sizeof(sa);
	
	if (argc < 3)
	{
		printf("Simple TCP/IP server.\n");
		printf("Usage: %s <program> <port>", argv[0]);
		return(1);
	}

	signal(SIGINT, signal_handler);

	port = atoi(argv[2]);	
	strcat(name, "ss-");
	strcat(name, argv[2]);

	if ((listener = socket(PF_INET, SOCK_STREAM, IPPROTO_IP)) < 0)
	{
		printf("%s: Unable to create a listener socket: %s\n", name, strerror(errno));
		return(2);
	}
	
	memset(&sa, 0, sa_len);
	sa.sin_family = AF_INET;
	sa.sin_port = htons(port);
	sa.sin_addr.s_addr = htonl(INADDR_ANY);
	
	if (bind(listener, (struct sockaddr *)&sa, sa_len) < 0)
	{
		printf("%s: Unable to bind port %i: %s\n", name, port, strerror(errno));
		return(3);
	}

	if (listen(listener, 5) < 0)
	{
		printf("%s: Unable to open listener: %s\n", name, strerror(errno));
		return(4);
	}

	for (;;)
	{
		char sendbuf[1023];
		int sent, length;
		FILE *l_prog;
		
		client = accept(listener, (struct sockaddr *)&sa, &sa_len);

		if (client < 0)
		{
			printf("%s: Unable to accpet: %s\n", name, strerror(errno));
			close(listener);
			return(5);
		}

		inet_ntop(AF_INET, &sa.sin_addr, dotted_ip, 15);
		printf("%s: Recived connection from %s.\n", name, dotted_ip);
		
		if ((l_prog = popen(argv[1], "r")) == NULL)
		{
			strcpy(sendbuf, "Unable to read system's ");
			strcat(sendbuf, argv[1]);
			strcat(sendbuf, "\n");
		}
		else
		{
			sendbuf[0] = '\0';
			fgets(sendbuf, 1023, l_prog);
		}
		
		length = strlen(sendbuf);
		sent = 0;
		
		while (sent < length)
		{
			int amt;
			
			if ((amt = write(client, sendbuf + sent, length - sent)) <= 0)
			{
				if (errno == EINTR)
					continue;
				else
				{
					printf("%s: Send error: %s\n", name, strerror(errno));
					break;
				}
			}
			
			sent += amt;
			
			if ((sent == length) && (length > 1))
			{
				sendbuf[0] = '\0';
				fgets(sendbuf, 1023, l_prog);
				length = strlen(sendbuf);
				sent = 0;
			}
		}

		pclose(l_prog);
		close(client);
	}

	return(0);
}