#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/socket.h>

/* is any body out there? */
int listener;
/* somebody is */
int client;

/* send a string to the client */
int sendtoclient(char *msg)
{
	int sent = 0;
	int length = strlen(msg);
	
	while (sent < length)
	{
		int amt;
		
		if ((amt = write(client, msg + sent, length - sent)) <= 0)
		{
			if (errno == EINTR)
				continue;
			else
			{
				printf("Send error: %s\n", strerror(errno));
				sent = -1;
				break;
			}
		}
		
		sent += amt;
	}
	
	return(sent);
}

void signal_handler(int signum)
{
	switch (signum)
	{
		case SIGINT:
			printf("\nRecived interrupt signal. Exiting.\n");
			close(client);
			close(listener);
			exit(0);
		default:
			printf("\nUnknown signal recieved. Ignoring.\n");
	}
}

int main(int argc, char *argv[])
{
	char dotted_ip[15];
	int port;
	struct sockaddr_in sa;
	socklen_t sa_len = sizeof(sa);

	/* does the command look ok? */
	printf("checking command line ...\n"); 
	if (argc != 2)
	{
		printf("Simple TCP/IP server.\n");
		printf("Usage: %s <port>\n", argv[0]);
		return(1);
	}

	/* set signal handler */
	printf("set signal handler ...\n"); 
	signal(SIGINT, signal_handler);

	/* what port are we using? */
	port = atoi(argv[1]);
	printf("using port %i ...\n", port); 
		
	/* listen for clients */
	printf("creating listener ...\n"); 
	if ((listener = socket(PF_INET, SOCK_STREAM, IPPROTO_IP)) < 0)
	{
		printf("Unable to create a listener socket: %s\n", strerror(errno));
		return(2);
	}
	
	/* fill sa */
	printf("filling sa ...\n"); 
	memset(&sa, 0, sa_len);
	sa.sin_family = AF_INET;
	sa.sin_port = htons(port);
	sa.sin_addr.s_addr = htonl(INADDR_ANY);
	
	/* bind socket to port */
	printf("binding listener ...\n"); 
	if (bind(listener, (struct sockaddr *)&sa, sa_len) < 0)
	{
		printf("Unable to bind port %i: %s\n", port, strerror(errno));
		return(3);
	}

	/* open listener */
	printf("opening listener ...\n"); 
	if (listen(listener, 5) < 0)
	{
		printf("Unable to open listener: %s\n", strerror(errno));
		return(4);
	}
	
	/* we are ready for connections */
	printf("main loop ...\n"); 
	for (;;)
	{
		char outbuf[1023];
		
		/* waiting ... */
		if ((client = accept(listener, (struct sockaddr *)&sa, &sa_len)) < 0)
		{
			printf("Unable to accpet: %s\n", strerror(errno));
			close(listener);
			return(5);
		}

		/* where is client? */
		inet_ntop(AF_INET, &sa.sin_addr, dotted_ip, 15);
		printf("Recived connection from %s.\n", dotted_ip);
		
		/* make and send message */
		strcpy(outbuf, "some greeting text\n");
		strcat(outbuf, "your ip is ");
		strcat(outbuf, dotted_ip);
		strcat(outbuf, "\n");
		printf("sent %i bytes to client\n", sendtoclient(outbuf));
		
		/* next? */
		close(client);
	}
	
	/* done */
	printf("finished ...\n"); 
	return(0);
}