#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/socket.h>

/* our socket */
int sock;

void signal_handler(int signum)
{
	switch (signum)
	{
		case SIGINT:
			printf("\nRecived interrupt signal. Exiting.\n");
			close(sock);
			exit(0);
		default:
			printf("\nUnknown signal %i recieved. Ignoring.\n", signum);
	}
}

int main(int argc, char *argv[])
{
	struct hostent *hostlist;
	char dotted_ip[15];
	struct sockaddr_in sa;
	
	/* did we get a command line with the right number of args */ 
	if (argc != 3)
	{
		printf("Simple TCP/IP client.\n");
		printf("Usage: %s <hostname | IPV4> <port>\n", argv[0]);
		return(1);
	}
	

	/* set signal handler */
	signal(SIGINT, signal_handler);

	/* resolve hostname */
	if ((hostlist = gethostbyname(argv[1])) == NULL)
	{
		printf("Can't resolve %s.\n", argv[1]);
		return(2);
	}
	
	/* did we get an IPv4 address with that? */
	if (hostlist->h_addrtype != AF_INET)
	{
		printf("%s doesn't seem to be IPv4.\n", argv[1]);
		return(3);
	}
	
	/* get dotted ip */
	inet_ntop(AF_INET, hostlist->h_addr_list[0], dotted_ip, 15); 
	
	/* create a socket */
	if ((sock = socket(PF_INET, SOCK_STREAM, IPPROTO_IP)) < 0)
	{
		printf("Unable to create a socket: %s\n", strerror(errno));
		return(4);
	}

	/* fill sa */
	memset(&sa, 0, sizeof(struct sockaddr_in));
	sa.sin_port = htons(atoi(argv[2]));
	memcpy(&sa.sin_addr, hostlist->h_addr_list[0], hostlist->h_length);
	sa.sin_family = AF_INET;
	
	/* connect socket */
	if (connect(sock, (struct sockaddr *)&sa, sizeof(sa)) < 0)
	{
		printf("Unable to connect: %s\n", strerror(errno));
		return(5);
	}
	
	putchar('\n');
	/* read one char at a time from socket */
	for(;;)
	{
		char ch;
		int amt;
		
		amt = read(sock, &ch, 1);

		if (amt < 0)
		{
			printf("Read error: %s\n", strerror(errno));
			break;
		}
		else if (amt == 0)
			break;
		
		putchar(ch);
		fflush(stdout);
	}
	putchar('\n');

	/* close socket */
	close(sock);

	/* done */
	return(0);
}