/*
 * Copyright James Morse Y2K+1, +2, +3
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <stdlib.h>
#include "bug6.h"
#include "look.h"
#include "food.h"
#include "terrain.h"

/* Is this a bug? */
inline int is_bug(char temp)
{
	return((temp >= L_RACE && temp <= H_RACE) ? YES : NO);
}

/* Can I walk here? */
inline int is_pass(char temp)
{
	return(((temp != WTR) && (temp != MNT) && (!is_bug(temp))) ? YES : NO);
}

/* How badly do I want it? */
inline float motivate(char temp, int depth)
{
	/* start with base desire from memory */
	float motivation = (float)bugs->things[(int)temp];

	/* adjust for herding instinct and mating desire */
	if (temp == bugs->race)
	{
		motivation *= (float)(HERD * depth / bugs->fov);
		motivation += (float)(bugs->food - MATE_LVL);
	}
	
	/* adjust for distance */
	motivation /= (float)depth;

	/* we don't run from food */
	if ((motivation < 0) && (temp == FOOD3))
		return(0.0);

	return(motivation);
}

/* -cos? */
inline int look_c(int vec)
{
      	switch (vec%4)
       	{
		case 0:
			return(-1);
               		break;
       		case 2:
			return(1);
               		break;
		default:
			return(0);
			break;
	}
}

/* recursive fractal look ... */
inline float look_b (int depth, int vec, int yo, int xo)
{
	float weight = 0;
	char temp = world[world_col * ((bugs->ypos + world_row + yo) % world_row) + ((bugs->xpos + world_col + xo) % world_col)];

	weight += motivate(temp, depth);

	if (is_pass (temp) && (depth < bugs->fov))
	{
        	weight += look_b(depth + 1, vec, yo + look_c(vec + 0), xo + look_c(vec + 1));
                if (depth < bugs->fov - 1)
       	        {
        	        look_b(depth + 1, vec + 1, yo, xo);
        	        look_b(depth + 1, vec + 3, yo, xo);
		}
	}
	
	return(weight);
}

/* Whats here? */
inline char peek (void)
{
	return(world[world_col * ((bugs->ypos + world_row + look_c(bugs->vector + 0)) % world_row) + ((bugs->xpos + world_col + look_c(bugs->vector + 1)) % world_col)]);
}

/* I'm going to do what? */
int look (void)
{
	struct bug *biten;
	char temp;
	float leftw = 0, rightw = 0, forwardw = 0;
	
	/* look for mate and/or food */
	temp = peek();

	if ((temp == bugs->race) && (bugs->food > MATE_LVL))
	{
		mate();
		if (bugs->things[(int)bugs->race] < MATE_LVL)
			++bugs->things[(int)bugs->race];
		/* exausted ... */
		return WAIT;
	} 
	
	if (bugs->things[(int)temp] > 0)
	{
		if (temp == FOOD3)
		{
			placefood();  
			bugs->food += FOOD_VAL;
			if (bugs->things[(int)FOOD3] < FOOD_VAL)
				++bugs->things[(int)FOOD3];
			return FORWARD;
		}

		if ((is_bug(temp)) && (temp != bugs->race))
		{
			/* who are we bitting? */
			biten = findbug((bugs->ypos + look_c(bugs->vector) + world_row) % world_row, (bugs->xpos + look_c(bugs->vector + 1) + world_col) % world_col);

			if (bugs->things[FOOD3] < 0)
				biten->things[(int)bugs->race] -= bugs->size;
			
			biten->food -= bugs->size + bugs->attack - biten->defend;

			if (biten->food < 0)
			{
				bugs->food += biten->size * BUG_FOOD * FOOD_VAL;
				bugs->things[(int)biten->race] += biten->size;
				bugs->things[FOOD3]--;

				if ((bugs->attack < biten->defend) && (bugs->attack < H_SKILL))
					if ((++bugs->attack + bugs->defend) > bugs->size)
						if (--bugs->defend < L_SKILL)
							bugs->defend = L_SKILL;

				die(biten);
			}

			else
			{
				if ((biten->defend < bugs->attack) && (biten->defend < H_SKILL))
					if ((++biten->defend + biten->attack) > biten->size)
						if (--biten->attack < L_SKILL)
							biten->attack = L_SKILL;
			}

			return WAIT;
		}
	}

	/* nothing of imedate interest ... gather data */
        forwardw = look_b(1, bugs->vector, look_c(bugs->vector + 0), look_c(bugs->vector + 1));
        rightw = look_b(2, bugs->vector + 1, look_c(bugs->vector+1), look_c(bugs->vector + 2));
        leftw = look_b(2, bugs->vector + 3, look_c(bugs->vector + 3), look_c(bugs->vector + 0));
        forwardw -= look_b(3, bugs->vector + 2, look_c(bugs->vector + 2), look_c(bugs->vector + 3));
	
	/* forward > left & right */
	if ((forwardw > leftw) && (forwardw > rightw))
        	return (((forwardw > 0) && (is_pass(temp))) ? FORWARD : getrandom(LEFT, RIGHT));

	/* left > forward & right */
	if ((leftw > rightw) && (leftw > forwardw))
        	return ((leftw > 0) ? LEFT : ((is_pass(temp)) ? getrandom(RIGHT, FORWARD) : RIGHT));

	/* right > left & forward */
	if ((rightw > leftw) && (rightw > forwardw))
        	return ((rightw > 0) ? RIGHT : ((is_pass(temp)) ? (getrandom(0, 1) ? LEFT : FORWARD) : LEFT));

	/* left & right > forward */
	if ((leftw == rightw) && (rightw > forwardw))
       		return getrandom(LEFT, RIGHT);

	/* forward & right > left */
	if ((forwardw == rightw) && (rightw > leftw))
               	return ((is_pass(temp)) ? getrandom(RIGHT, FORWARD) : RIGHT);

	/* forward & left > right */
	if ((forwardw == leftw) && (leftw > rightw))
               	return ((is_pass(temp)) ? (getrandom(0, 1) ? LEFT : FORWARD) : LEFT);

	/* all equil ... bug is stumped ... this is clever :) */
	return getrandom(WAIT, (RIGHT + is_pass (temp)));
}

