/*
 * Copyright James Morse Y2K +1, +2, +3
 * This is GPLed software 
 * please read COPYING
 *
 */

/* Bug6 header file */
#ifndef BUG6_H
#define BUG6_H 

/* virtual world */
int world_row;
int world_col;
char *world;

/* size of physical display */
int rrow;
int rcol;

/* start up population */
void start (void);

/* exit gracefuly */
void stop(int);

/* screen functions */
/* normal - show world */
void display(int, int);
/* show stats */
void stat(int);
int u1mode;
int u2mode;

/* bug funtions */
struct bug* findbug (int, int);
void die (struct bug *);
void mate (void);

/* get a random int in the range min to max */
#define getrandom( min, max ) ((rand() % (int) (((max) + 1) - (min))) + (min))

/* used to set intial condition in start() ... */
#define NUM_BUGS (world_col * world_row * .01)

/* bug food val factor
 * biten->size * BUG_FOOD * FOOD_VAL */
#define BUG_FOOD 6

/* how much food is used in mateing */
#define MATE_COST (FOOD_VAL * bugs->size)
/* how much food required to mate */
#define MATE_LVL (4 * MATE_COST)
/* how much food is needed to split */
#define SPLIT_LVL (MATE_LVL * 2)

/* racial forgetfulness */
#define RF (.75)
/* noise to foster learning */
#define ID 5

/* herding instinct */
#define HERD 3

/* what races? */
#define L_RACE 'A'
#define H_RACE 'Z'

/* what sizes? */
#define L_SIZE 2
#define H_SIZE 100
#define D_SIZE 10

/* what skills? */
#define L_SKILL 0
#define H_SKILL 100
#define D_SKILL 10

/* what fov? */
#define L_FOV 1
#define H_FOV 10

/* a bug does what ??? */
#define WAIT 0
#define LEFT 1
#define RIGHT 2
#define FORWARD 3
/* and uses some food */
#define UFF (1 + sqrt(bugs->size))
#define WAIT_F (UFF)
#define TURN_F (1.4 * UFF)
#define MOVE_F (2 * UFF)

/* the bug structure */
struct bug
{
	int xpos, ypos, vector;		/* position and heading */ 
	int food;			/* is bug well fed */
	char race;			/* */
	int age;			/* how long has bug been alive */
	int gen;			/* what generation is it */
	int size;			/* how big is bug*/
	int attack;			/* is it good at killing */
	int defend;			/* at defending itself */
	int fov;			/* how far the bug sees */
	int things[256];		/* motivational force for things a bug might run into */
	struct bug *prev;		/* preceding bug in list */
	struct bug *next;		/* next bug in list */
};

/* current & "first" */
struct bug *bugs, *first;

/* status, high food, high gen, oldest, high kill bugs ... */
struct bug *sb, *hf, *hg, *old, *hk;

#endif /* BUG6_H */

