/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <curses.h>
#include <math.h>
#include "bug5.h"

void init (void)
{
	initscr ();

	// set world dimensions	
	// important COLS & LINES == 0 till after initscr()
	world_col = (int)(COLS * world_size);
	world_row = (int)(LINES * world_size) - 1;
	
	init_kb ();
	srand ((unsigned) time ( NULL ));
	world_pad = newpad (world_row, world_col);
	clear ();
	start ();

	return;
}

void start (void)
{
	struct bug *temp, *x;
	int loop, loop2, val;
	char tempch[3];

	// generate underlying terrain
	generateterrain ();

	// place food
	for (loop = 1; loop <= NUM_FOOD; loop++)
		placefood ();
	
	// create bugs
	for (loop = 1; loop <= NUM_BUGS; loop++)
	{
		temp = (struct bug *) malloc (sizeof (struct bug));

		// don't put bugs on MNT or in WTR
		do 
		{
			temp->xpos = getrandom (0, world_col - 1);
			temp->ypos = getrandom (0, world_row - 1);
			val = mvwinnstr (world_pad, temp->ypos, temp->xpos, tempch, 1);
		}
		while (tempch[0] != SPACE);
		
		temp->vector = getrandom (0, 3);
		temp->race = (char)getrandom (L_RACE, H_RACE);
		temp->size = getrandom (L_SIZE, H_SIZE);
		temp->attack = getrandom (L_SKILL, H_SKILL) / 2;
		temp->defend = getrandom (L_SKILL, H_SKILL) / 2;

		while ((temp->attack + temp->defend) > temp->size)
		{
			if (--temp->attack < L_SKILL)
				temp->attack = L_SKILL;

			if (--temp->defend < L_SKILL)
				temp->defend = L_SKILL;
		}

		temp->fov = sqrt (temp->size);
		temp->food = 10000;
		temp->gen = 1;
		temp->age = 0;

		for (loop2 = 0; loop2 < 256; loop2++)
		{
			if (is_bug ((char)loop2))
				temp->things[loop2] = getrandom (-ID, ID);
			else
				temp->things[loop2] = 0;
		}
		temp->things[FOOD3] = FOOD_VAL;
		
		if (loop == 1)
			bugs = temp;
		else
		{
			x->next = temp;
			temp->prev = x;
		}
		x = temp;
	}
	temp->next = bugs;
	bugs->prev = temp;
	return;
}

void stop (void)
{
	delwin (world_pad);
	close_kb ();
	endwin ();
	exit (0);
}
