/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <curses.h>
#include <limits.h>
#include <stdlib.h>
#include "bug5.h"

#define MIN 0
#define AVG 1
#define MAX 2

struct counts
{ 
	int pop;
	char race;
	int age[3];
	int food[3];
	int gen[3];
	int size[3];
	int attack[3];
	int defend[3];
	int fov[3];
};

/* display panel for USER stats */
void u_panel (struct counts *race, int umode)
{
	switch (umode)
	{
		case 0:
			wprintw (stdscr, "%i	%i	%i	", race->age[MIN], race->age[AVG], race->age[MAX]);
			break;
		case 1:
			wprintw (stdscr, "%i	%i	%i	", race->food[MIN], race->food[AVG], race->food[MAX]);
			break;
		case 2:
			wprintw (stdscr, "%i	%i	%i	", race->gen[MIN], race->gen[AVG], race->gen[MAX]);
			break;
		case 3:	
			wprintw (stdscr, "%i	%i	%i	", race->size[MIN], race->size[AVG], race->size[MAX]);
			break;
		case 4:
			wprintw (stdscr, "%i	%i	%i	", race->attack[MIN], race->attack[AVG], race->attack[MAX]);
			break;
		case 5:
			wprintw (stdscr, "%i	%i	%i	", race->defend[MIN], race->defend[AVG], race->defend[MAX]);
			break;
		case 6:
			wprintw (stdscr, "%i	%i	%i	", race->fov[MIN], race->fov[AVG], race->fov[MAX]);
			break;
		default:
			break;
	}
	
	return;
}

/* qsort helper funtion */
int cmp_race (const void *i1, const void *i2)
{
	return ((* (struct counts *) i2).pop - (* (struct counts *) i1).pop);
}

/* start in known sane state */
void init_counts (struct counts *temp)
{
	temp->pop = 0;

	temp->age[MIN] = INT_MAX;
	temp->age[AVG] = 0;
	temp->age[MAX] = INT_MIN;

	temp->food[MIN] = INT_MAX;
	temp->food[AVG] = 0;
	temp->food[MAX] = INT_MIN;

	temp->gen[MIN] = INT_MAX;
	temp->gen[AVG] = 0;
	temp->gen[MAX] = INT_MIN;

	temp->size[MIN] = INT_MAX;
	temp->size[AVG] = 0;
	temp->size[MAX] = INT_MIN;

	temp->attack[MIN] = INT_MAX;
	temp->attack[AVG] = 0;
	temp->attack[MAX] = INT_MIN;

	temp->defend[MIN] = INT_MAX;
	temp->defend[AVG] = 0;
	temp->defend[MAX] = INT_MIN;

	temp->fov[MIN] = INT_MAX;
	temp->fov[AVG] = 0;
	temp->fov[MAX] = INT_MIN;

	return;
}

void stat (int mam)
{
	struct bug *temp1 = bugs;
	struct counts races[256];
	int temp;
	char *smam;
	char *ustat[7] = {"age", "food", "gen", "size", "attack", "defend", "fov"};
	clear ();
	
	for (temp = 0; temp < 256; temp++)
	{
		init_counts (&races[temp]);
		races[temp].race = temp;
	}

	do
	{
		races[0].age[AVG] += temp1->age;
		races[0].food[AVG] += temp1->food;
		races[0].gen[AVG] += temp1->gen;
		races[0].size[AVG] += temp1->size;
		races[0].attack[AVG] += temp1->attack;
		races[0].defend[AVG] += temp1->defend;
		races[0].fov[AVG] += temp1->fov;

		races[temp1->race].pop++;

		if (temp1->age < races[temp1->race].age[MIN])
			races[temp1->race].age[MIN] = temp1->age;
		races[temp1->race].age[AVG] += temp1->age;
		if (temp1->age > races[temp1->race].age[MAX])
			races[temp1->race].age[MAX] = temp1->age;

		if (temp1->food < races[temp1->race].food[MIN])
			races[temp1->race].food[MIN] = temp1->food;
		races[temp1->race].food[AVG] += temp1->food;
		if (temp1->food > races[temp1->race].food[MAX])
			races[temp1->race].food[MAX] = temp1->food;

		if (temp1->gen < races[temp1->race].gen[MIN])
			races[temp1->race].gen[MIN] = temp1->gen;
		races[temp1->race].gen[AVG] += temp1->gen;
		if (temp1->gen > races[temp1->race].gen[MAX])
			races[temp1->race].gen[MAX] = temp1->gen;

		if (temp1->size < races[temp1->race].size[MIN])
			races[temp1->race].size[MIN] = temp1->size;
		races[temp1->race].size[AVG] += temp1->size;
		if (temp1->size > races[temp1->race].size[MAX])
			races[temp1->race].size[MAX] = temp1->size;

		if (temp1->attack < races[temp1->race].attack[MIN])
			races[temp1->race].attack[MIN] = temp1->attack;
		races[temp1->race].attack[AVG] += temp1->attack;
		if (temp1->attack > races[temp1->race].attack[MAX])
			races[temp1->race].attack[MAX] = temp1->attack;

		if (temp1->defend < races[temp1->race].defend[MIN])
			races[temp1->race].defend[MIN] = temp1->defend;
		races[temp1->race].defend[AVG] += temp1->defend;
		if (temp1->defend > races[temp1->race].defend[MAX])
			races[temp1->race].defend[MAX] = temp1->defend;

		if (temp1->fov < races[temp1->race].fov[MIN])
			races[temp1->race].fov[MIN] = temp1->fov;
		races[temp1->race].fov[AVG] += temp1->fov;
		if (temp1->fov > races[temp1->race].fov[MAX])
			races[temp1->race].fov[MAX] = temp1->fov;

		temp1 = temp1->next;
		races[0].pop++;
	}
	while (temp1 != bugs);	
	
	for (temp = 0; temp < 256; temp++)
		if(races[temp].pop != 0)	
		{
			races[temp].age[AVG] /= races[temp].pop;
			races[temp].food[AVG] /= races[temp].pop;
			races[temp].gen[AVG] /= races[temp].pop;
			races[temp].size[AVG] /= races[temp].pop;
			races[temp].attack[AVG] /= races[temp].pop;
			races[temp].defend[AVG] /= races[temp].pop;
			races[temp].fov[AVG] /= races[temp].pop;
		}
		     
	qsort (races, 256, sizeof (struct counts), cmp_race);

	switch (mam)
	{
		case MIN:
			smam = "MIN";
			break;
		case AVG:
			smam = "AVG";
			break;
		case MAX:
			smam = "MAX";
			break;
		default:
			smam = "USER";
			break;
	}

	wprintw (stdscr, "Status -- %i/%i -- %.2f -- %i -- %s -- %s -- %s --\n", roughness, grid_size, world_size, VER, __DATE__, __TIME__, smam);

	wprintw (stdscr, "race	pop	age	food	gen	size	attack	defend	fov\n");
	wprintw (stdscr, "all	%i	%i	%i	%i	%i	%i	%i	%i\n", races[0].pop, races[0].age[AVG], races[0].food[AVG], races[0].gen[AVG], races[0].size[AVG], races[0].attack[AVG], races[0].defend[AVG], races[0].fov[AVG]);

	if (mam == 3)
	{
		wprintw (stdscr, "			%s			%s\n", ustat[u1mode], ustat[u2mode]);
		wprintw (stdscr, "race	pop	MIN	AVG	MAX	MIN	AVG	MAX\n");
	}
	
	else
	{
		wprintw (stdscr, "\n");
		wprintw (stdscr, "race	pop	age	food	gen	size	attack	defend	fov\n");
	}
	
	for (temp = 1; temp < (LINES - 6); temp++)
		if (races[temp].pop > 0)
		{	
			if (mam == 3)
			{
				wprintw (stdscr, "%c	%i	", races[temp].race, races[temp].pop);
				
				u_panel (&races[temp], u1mode);
				u_panel (&races[temp], u2mode);
				
				wprintw (stdscr, "\n");
			}	
			else
				wprintw (stdscr, "%c	%i	%i	%i	%i	%i	%i	%i	%i\n", races[temp].race, races[temp].pop, races[temp].age[mam], races[temp].food[mam], races[temp].gen[mam], races[temp].size[mam], races[temp].attack[mam], races[temp].defend[mam], races[temp].fov[mam]);
		}
	return;
}

