/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <curses.h>
#include <limits.h>
#include <stdlib.h>
#include "bug5.h"

#define MIN 0
#define AVG 1
#define MAX 2

struct counts
{ 
	int pop;
	char race;
	int age[3];
	int food[3];
	int gen[3];
	int size[3];
	int fov[3];
};

int cmp_race (const void *i1, const void *i2)
{
	struct counts r1 = * (struct counts *) i1;
	struct counts r2 = * (struct counts *) i2;
	return (r2.pop - r1.pop);
}

void init_counts (struct counts *temp)
{
	temp->pop = 0;

	temp->age[MIN] = INT_MAX;
	temp->age[AVG] = 0;
	temp->age[MAX] = INT_MIN;

	temp->food[MIN] = INT_MAX;
	temp->food[AVG] = 0;
	temp->food[MAX] = INT_MIN;

	temp->gen[MIN] = INT_MAX;
	temp->gen[AVG] = 0;
	temp->gen[MAX] = INT_MIN;

	temp->size[MIN] = INT_MAX;
	temp->size[AVG] = 0;
	temp->size[MAX] = INT_MIN;

	temp->fov[MIN] = INT_MAX;
	temp->fov[AVG] = 0;
	temp->fov[MAX] = INT_MIN;

	return;
}

void stat (void)
{
	struct bug *temp1 = bugs;
	struct counts races[256];
	int temp;
		
	clear ();
	for (temp = 0; temp < 256; temp++)
	{
		init_counts (&races[temp]);
		races[temp].race = temp;
	}

	do
	{
		races[0].age[AVG] += temp1->age;
		races[0].food[AVG] += temp1->food;
		races[0].gen[AVG] += temp1->gen;
		races[0].size[AVG] += temp1->size;
		races[0].fov[AVG] += temp1->fov;

		races[temp1->race].pop++;

		if (temp1->age < races[temp1->race].age[MIN])
			races[temp1->race].age[MIN] = temp1->age;
		races[temp1->race].age[AVG] += temp1->age;
		if (temp1->age > races[temp1->race].age[MAX])
			races[temp1->race].age[MAX] = temp1->age;

		if (temp1->food < races[temp1->race].food[MIN])
			races[temp1->race].food[MIN] = temp1->food;
		races[temp1->race].food[AVG] += temp1->food;
		if (temp1->food > races[temp1->race].food[MAX])
			races[temp1->race].food[MAX] = temp1->food;

		if (temp1->gen < races[temp1->race].gen[MIN])
			races[temp1->race].gen[MIN] = temp1->gen;
		races[temp1->race].gen[AVG] += temp1->gen;
		if (temp1->gen > races[temp1->race].gen[MAX])
			races[temp1->race].gen[MAX] = temp1->gen;

		if (temp1->size < races[temp1->race].size[MIN])
			races[temp1->race].size[MIN] = temp1->size;
		races[temp1->race].size[AVG] += temp1->size;
		if (temp1->size > races[temp1->race].size[MAX])
			races[temp1->race].size[MAX] = temp1->size;

		if (temp1->fov < races[temp1->race].fov[MIN])
			races[temp1->race].fov[MIN] = temp1->fov;
		races[temp1->race].fov[AVG] += temp1->fov;
		if (temp1->fov > races[temp1->race].fov[MAX])
			races[temp1->race].fov[MAX] = temp1->fov;

		temp1 = temp1->next;
		races[0].pop++;
	}
	while (temp1 != bugs);	
	
	for (temp = 0; temp < 256; temp++)
		if(races[temp].pop != 0)	
		{
			races[temp].age[AVG] /= races[temp].pop;
			races[temp].food[AVG] /= races[temp].pop;
			races[temp].gen[AVG] /= races[temp].pop;
			races[temp].size[AVG] /= races[temp].pop;
			races[temp].fov[AVG] /= races[temp].pop;
		}
		     
	wprintw (stdscr, "Status -- %i/%i -- %.2f -- %i -- %s -- %s -- \n", roughness, grid_size, world_size, VER, __DATE__, __TIME__);
	wprintw (stdscr, "race	pop	age	amax	afood	savg	smax	favg	fmax \n");
	wprintw (stdscr, "all	%i	%i		%i			%i	     \n", races[0].pop, races[0].age[AVG], races[0].food[AVG], races[0].fov[AVG]);

	qsort (races, 256, sizeof (struct counts), cmp_race);
	
	for (temp = 1; temp < (LINES - 4); temp++)
		if (races[temp].pop > 0)
			wprintw (stdscr, "%c	%i	%i	%i	%i	%i	%i	%i	%i \n", races[temp].race, races[temp].pop, races[temp].age[AVG], races[temp].age[MAX], races[temp].food[AVG], races[temp].size[AVG], races[temp].size[MAX], races[temp].fov[AVG], races[temp].fov[MAX]);

	return;
}

