/*
 * Copyright James Morse Y2K+1
 * This is GPLed software 
 * please read COPYING
 *
 */

#include <curses.h>
#include <math.h>
#include "bug5.h"

int is_bug (char temp)
{
	return ((temp >= L_RACE && temp <= H_RACE) ? 1 : 0);
}

int is_pass (char temp)
{
	return (((temp == WTR) || (temp == MNT) || (is_bug(temp))) ? 0 : 1);
}

float motivate (char temp, int depth)
{
	float motivation = 0;

	if (bugs->food < MATE_LVL)
		motivation = (float)bugs->things[temp] / (float)depth;

	else if (temp == bugs->race)
		motivation = (float)(bugs->food - MATE_LVL) / (float)depth;
	
	else
		motivation = (float)bugs->things[temp] / (float)(depth * 2);
		
	if ((motivation < 0) && (temp == FOOD3))
		return (0);

	return (motivation);
}

int look_c (int vec)
{
      	switch (vec%4)
       	{
		case (0):
			return (-1);
               		break;
       		case (2):
			return (1);
               		break;
		default:
			return (0);
			break;
	}
}

// recursive fractal look ...
float look_b (int depth, int vec, int yo, int xo)
{
	float weight = 0;
	int val;
	char temp[3];

	val = mvwinnstr (world_pad, (bugs->ypos + world_row + yo) % world_row, (bugs->xpos + world_col + xo) % world_col, temp, 1);
	weight += motivate (temp[0], depth);

	if (is_pass (temp[0]) && (depth < bugs->fov))
	{
        	weight += look_b (depth + 1, vec, yo + look_c(vec + 0), xo + look_c (vec + 1));
                if (depth < bugs->fov - 1)
       	        {
        	        look_b (depth + 1, vec + 1, yo, xo);
        	        look_b (depth + 1, vec + 3, yo, xo);
		}
	}
	
	return (weight);
}

char peek ()
{
	int val;
	char temp[3];

	val = mvwinnstr (world_pad, (bugs->ypos + world_row + look_c (bugs->vector + 0)) % world_row, (bugs->xpos + world_col + look_c (bugs->vector + 1)) % world_col, temp, 1);
	
	return (temp[0]);
}

int look (void)
{
	struct bug *biten;
	char temp;
	float leftw = 0, rightw = 0, forwardw = 0;
	
	// look for mate and/or food
	temp = peek ();
	if ((temp == bugs->race) && (bugs->food > MATE_LVL))
	{
		mate ();
		// exausted ...
		return WAIT;
	} 
	
	if (bugs->things[temp] > 0)
	{
		if (temp == FOOD3)
		{
			placefood ();  
			bugs->food += FOOD_VAL;
			return FORWARD;
		}
		if ((is_bug (temp)) && (temp != bugs->race))
		{
			biten = findbug ((bugs->ypos + look_c (bugs->vector) + world_row) % world_row, (bugs->xpos + look_c (bugs->vector + 1) + world_col) % world_col);
			if (bugs->things[FOOD3] < 0)
				biten->things[bugs->race] -= bugs->size;
			biten->food -= bugs->size;
			if (biten->food < 0)
			{
				bugs->food += biten->size * BUG_FOOD * FOOD_VAL;
				bugs->things[biten->race] += biten->size;
				bugs->things[FOOD3] -= biten->size;
				die (biten);
			}
			return WAIT;
		}
	}

        forwardw = look_b (1, bugs->vector, look_c (bugs->vector + 0), look_c (bugs->vector + 1));
        rightw = look_b (2, bugs->vector + 1, look_c (bugs->vector+1), look_c (bugs->vector + 2));
        leftw = look_b (2, bugs->vector + 3, look_c (bugs->vector + 3), look_c (bugs->vector + 0));
        forwardw -= look_b (3, bugs->vector + 2, look_c (bugs->vector + 2), look_c (bugs->vector + 3));
	
	// forward > left & right
	if ((forwardw > leftw) && (forwardw > rightw))
        	return (((forwardw > 0) && (is_pass (temp))) ? FORWARD : getrandom (LEFT, RIGHT));

	// left > forward & right
	if ((leftw > rightw) && (leftw > forwardw))
        	return ((leftw > 0) ? LEFT : ((is_pass (temp)) ? getrandom (RIGHT, FORWARD) : RIGHT));

	// right > left & forward
	if ((rightw > leftw) && (rightw > forwardw))
        	return ((rightw > 0) ? RIGHT : ((is_pass (temp)) ? (getrandom (0, 1) ? LEFT : FORWARD) : LEFT));

	// left & right > forward
	if ((leftw == rightw) && (rightw > forwardw))
       		return getrandom (LEFT, RIGHT);

	// forward & right > left
	if ((forwardw == rightw) && (rightw > leftw))
               	return ((is_pass (temp)) ? getrandom (RIGHT, FORWARD) : RIGHT);

	// forward & left > right
	if ((forwardw == leftw) && (leftw > rightw))
               	return ((is_pass (temp)) ? (getrandom (0, 1) ? LEFT : FORWARD) : LEFT);

	// all equil ... bug is stumped ... this is clever :)
	return getrandom (WAIT, (RIGHT + is_pass (temp)));
}

